/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.CompatibilityModeConfiguration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.DataContainerConfiguration;
import org.infinispan.configuration.cache.DeadlockDetectionConfiguration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SecurityConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StoreAsBinaryConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.UnsafeConfiguration;
import org.infinispan.configuration.cache.VersioningConfiguration;

public class Configuration {
    private final ClusteringConfiguration clusteringConfiguration;
    private final CustomInterceptorsConfiguration customInterceptorsConfiguration;
    private final DataContainerConfiguration dataContainerConfiguration;
    private final DeadlockDetectionConfiguration deadlockDetectionConfiguration;
    private final EvictionConfiguration evictionConfiguration;
    private final ExpirationConfiguration expirationConfiguration;
    private final IndexingConfiguration indexingConfiguration;
    private final InvocationBatchingConfiguration invocationBatchingConfiguration;
    private final JMXStatisticsConfiguration jmxStatisticsConfiguration;
    private final PersistenceConfiguration persistenceConfiguration;
    private final LockingConfiguration lockingConfiguration;
    private final StoreAsBinaryConfiguration storeAsBinaryConfiguration;
    private final TransactionConfiguration transactionConfiguration;
    private final VersioningConfiguration versioningConfiguration;
    private final UnsafeConfiguration unsafeConfiguration;
    private final Map<Class<?>, ?> moduleConfiguration;
    private final SecurityConfiguration securityConfiguration;
    private final SitesConfiguration sitesConfiguration;
    private final CompatibilityModeConfiguration compatibilityConfiguration;

    Configuration(ClusteringConfiguration clusteringConfiguration, CustomInterceptorsConfiguration customInterceptorsConfiguration, DataContainerConfiguration dataContainerConfiguration, DeadlockDetectionConfiguration deadlockDetectionConfiguration, EvictionConfiguration evictionConfiguration, ExpirationConfiguration expirationConfiguration, IndexingConfiguration indexingConfiguration, InvocationBatchingConfiguration invocationBatchingConfiguration, JMXStatisticsConfiguration jmxStatisticsConfiguration, PersistenceConfiguration persistenceConfiguration, LockingConfiguration lockingConfiguration, SecurityConfiguration securityConfiguration, StoreAsBinaryConfiguration storeAsBinaryConfiguration, TransactionConfiguration transactionConfiguration, UnsafeConfiguration unsafeConfiguration, VersioningConfiguration versioningConfiguration, SitesConfiguration sitesConfiguration, CompatibilityModeConfiguration compatibilityConfiguration, List<?> modules) {
        this.clusteringConfiguration = clusteringConfiguration;
        this.customInterceptorsConfiguration = customInterceptorsConfiguration;
        this.dataContainerConfiguration = dataContainerConfiguration;
        this.deadlockDetectionConfiguration = deadlockDetectionConfiguration;
        this.evictionConfiguration = evictionConfiguration;
        this.expirationConfiguration = expirationConfiguration;
        this.indexingConfiguration = indexingConfiguration;
        this.invocationBatchingConfiguration = invocationBatchingConfiguration;
        this.jmxStatisticsConfiguration = jmxStatisticsConfiguration;
        this.persistenceConfiguration = persistenceConfiguration;
        this.lockingConfiguration = lockingConfiguration;
        this.storeAsBinaryConfiguration = storeAsBinaryConfiguration;
        this.transactionConfiguration = transactionConfiguration;
        this.unsafeConfiguration = unsafeConfiguration;
        this.versioningConfiguration = versioningConfiguration;
        this.securityConfiguration = securityConfiguration;
        this.sitesConfiguration = sitesConfiguration;
        this.compatibilityConfiguration = compatibilityConfiguration;
        HashMap modulesMap = new HashMap();
        for (Object module : modules) {
            modulesMap.put(module.getClass(), module);
        }
        this.moduleConfiguration = Collections.unmodifiableMap(modulesMap);
    }

    public ClusteringConfiguration clustering() {
        return this.clusteringConfiguration;
    }

    public CustomInterceptorsConfiguration customInterceptors() {
        return this.customInterceptorsConfiguration;
    }

    public DataContainerConfiguration dataContainer() {
        return this.dataContainerConfiguration;
    }

    public DeadlockDetectionConfiguration deadlockDetection() {
        return this.deadlockDetectionConfiguration;
    }

    public EvictionConfiguration eviction() {
        return this.evictionConfiguration;
    }

    public ExpirationConfiguration expiration() {
        return this.expirationConfiguration;
    }

    public IndexingConfiguration indexing() {
        return this.indexingConfiguration;
    }

    public InvocationBatchingConfiguration invocationBatching() {
        return this.invocationBatchingConfiguration;
    }

    public JMXStatisticsConfiguration jmxStatistics() {
        return this.jmxStatisticsConfiguration;
    }

    public PersistenceConfiguration persistence() {
        return this.persistenceConfiguration;
    }

    public LockingConfiguration locking() {
        return this.lockingConfiguration;
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.moduleConfiguration.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.moduleConfiguration;
    }

    public StoreAsBinaryConfiguration storeAsBinary() {
        return this.storeAsBinaryConfiguration;
    }

    public TransactionConfiguration transaction() {
        return this.transactionConfiguration;
    }

    public UnsafeConfiguration unsafe() {
        return this.unsafeConfiguration;
    }

    public SecurityConfiguration security() {
        return this.securityConfiguration;
    }

    public SitesConfiguration sites() {
        return this.sitesConfiguration;
    }

    public VersioningConfiguration versioning() {
        return this.versioningConfiguration;
    }

    public CompatibilityModeConfiguration compatibility() {
        return this.compatibilityConfiguration;
    }

    public String toString() {
        return "Configuration{clustering=" + this.clusteringConfiguration + ", customInterceptors=" + this.customInterceptorsConfiguration + ", dataContainer=" + this.dataContainerConfiguration + ", deadlockDetection=" + this.deadlockDetectionConfiguration + ", eviction=" + this.evictionConfiguration + ", expiration=" + this.expirationConfiguration + ", indexing=" + this.indexingConfiguration + ", invocationBatching=" + this.invocationBatchingConfiguration + ", jmxStatistics=" + this.jmxStatisticsConfiguration + ", persistence=" + this.persistenceConfiguration + ", locking=" + this.lockingConfiguration + ", modules=" + this.moduleConfiguration + ", security=" + this.securityConfiguration + ", storeAsBinary=" + this.storeAsBinaryConfiguration + ", transaction=" + this.transactionConfiguration + ", versioning=" + this.versioningConfiguration + ", unsafe=" + this.unsafeConfiguration + ", sites=" + this.sitesConfiguration + ", compatibility=" + this.compatibilityConfiguration + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusteringConfiguration == null ? 0 : this.clusteringConfiguration.hashCode());
        result = 31 * result + (this.compatibilityConfiguration == null ? 0 : this.compatibilityConfiguration.hashCode());
        result = 31 * result + (this.customInterceptorsConfiguration == null ? 0 : this.customInterceptorsConfiguration.hashCode());
        result = 31 * result + (this.dataContainerConfiguration == null ? 0 : this.dataContainerConfiguration.hashCode());
        result = 31 * result + (this.deadlockDetectionConfiguration == null ? 0 : this.deadlockDetectionConfiguration.hashCode());
        result = 31 * result + (this.evictionConfiguration == null ? 0 : this.evictionConfiguration.hashCode());
        result = 31 * result + (this.expirationConfiguration == null ? 0 : this.expirationConfiguration.hashCode());
        result = 31 * result + (this.indexingConfiguration == null ? 0 : this.indexingConfiguration.hashCode());
        result = 31 * result + (this.invocationBatchingConfiguration == null ? 0 : this.invocationBatchingConfiguration.hashCode());
        result = 31 * result + (this.jmxStatisticsConfiguration == null ? 0 : this.jmxStatisticsConfiguration.hashCode());
        result = 31 * result + (this.lockingConfiguration == null ? 0 : this.lockingConfiguration.hashCode());
        result = 31 * result + (this.moduleConfiguration == null ? 0 : this.moduleConfiguration.hashCode());
        result = 31 * result + (this.persistenceConfiguration == null ? 0 : this.persistenceConfiguration.hashCode());
        result = 31 * result + (this.securityConfiguration == null ? 0 : this.securityConfiguration.hashCode());
        result = 31 * result + (this.sitesConfiguration == null ? 0 : this.sitesConfiguration.hashCode());
        result = 31 * result + (this.storeAsBinaryConfiguration == null ? 0 : this.storeAsBinaryConfiguration.hashCode());
        result = 31 * result + (this.transactionConfiguration == null ? 0 : this.transactionConfiguration.hashCode());
        result = 31 * result + (this.unsafeConfiguration == null ? 0 : this.unsafeConfiguration.hashCode());
        result = 31 * result + (this.versioningConfiguration == null ? 0 : this.versioningConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (this.clusteringConfiguration == null ? other.clusteringConfiguration != null : !this.clusteringConfiguration.equals(other.clusteringConfiguration)) {
            return false;
        }
        if (this.compatibilityConfiguration == null ? other.compatibilityConfiguration != null : !this.compatibilityConfiguration.equals(other.compatibilityConfiguration)) {
            return false;
        }
        if (this.customInterceptorsConfiguration == null ? other.customInterceptorsConfiguration != null : !this.customInterceptorsConfiguration.equals(other.customInterceptorsConfiguration)) {
            return false;
        }
        if (this.dataContainerConfiguration == null ? other.dataContainerConfiguration != null : !this.dataContainerConfiguration.equals(other.dataContainerConfiguration)) {
            return false;
        }
        if (this.deadlockDetectionConfiguration == null ? other.deadlockDetectionConfiguration != null : !this.deadlockDetectionConfiguration.equals(other.deadlockDetectionConfiguration)) {
            return false;
        }
        if (this.evictionConfiguration == null ? other.evictionConfiguration != null : !this.evictionConfiguration.equals(other.evictionConfiguration)) {
            return false;
        }
        if (this.expirationConfiguration == null ? other.expirationConfiguration != null : !this.expirationConfiguration.equals(other.expirationConfiguration)) {
            return false;
        }
        if (this.indexingConfiguration == null ? other.indexingConfiguration != null : !this.indexingConfiguration.equals(other.indexingConfiguration)) {
            return false;
        }
        if (this.invocationBatchingConfiguration == null ? other.invocationBatchingConfiguration != null : !this.invocationBatchingConfiguration.equals(other.invocationBatchingConfiguration)) {
            return false;
        }
        if (this.jmxStatisticsConfiguration == null ? other.jmxStatisticsConfiguration != null : !this.jmxStatisticsConfiguration.equals(other.jmxStatisticsConfiguration)) {
            return false;
        }
        if (this.lockingConfiguration == null ? other.lockingConfiguration != null : !this.lockingConfiguration.equals(other.lockingConfiguration)) {
            return false;
        }
        if (this.moduleConfiguration == null ? other.moduleConfiguration != null : !this.moduleConfiguration.equals(other.moduleConfiguration)) {
            return false;
        }
        if (this.persistenceConfiguration == null ? other.persistenceConfiguration != null : !this.persistenceConfiguration.equals(other.persistenceConfiguration)) {
            return false;
        }
        if (this.securityConfiguration == null ? other.securityConfiguration != null : !this.securityConfiguration.equals(other.securityConfiguration)) {
            return false;
        }
        if (this.sitesConfiguration == null ? other.sitesConfiguration != null : !this.sitesConfiguration.equals(other.sitesConfiguration)) {
            return false;
        }
        if (this.storeAsBinaryConfiguration == null ? other.storeAsBinaryConfiguration != null : !this.storeAsBinaryConfiguration.equals(other.storeAsBinaryConfiguration)) {
            return false;
        }
        if (this.transactionConfiguration == null ? other.transactionConfiguration != null : !this.transactionConfiguration.equals(other.transactionConfiguration)) {
            return false;
        }
        if (this.unsafeConfiguration == null ? other.unsafeConfiguration != null : !this.unsafeConfiguration.equals(other.unsafeConfiguration)) {
            return false;
        }
        return !(this.versioningConfiguration == null ? other.versioningConfiguration != null : !this.versioningConfiguration.equals(other.versioningConfiguration));
    }
}

