/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractTransportConfigurationChildBuilder;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class RecoveryConfigurationBuilder
extends AbstractTransportConfigurationChildBuilder
implements Builder<RecoveryConfiguration> {
    private final AttributeSet attributes = RecoveryConfiguration.attributeDefinitionSet();

    RecoveryConfigurationBuilder(TransactionConfigurationBuilder builder) {
        super(builder);
    }

    public RecoveryConfigurationBuilder enable() {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set(true);
        return this;
    }

    public RecoveryConfigurationBuilder disable() {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set(false);
        return this;
    }

    public RecoveryConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set(enabled);
        return this;
    }

    boolean isEnabled() {
        return this.attributes.attribute(RecoveryConfiguration.ENABLED).get();
    }

    public RecoveryConfigurationBuilder recoveryInfoCacheName(String recoveryInfoName) {
        this.attributes.attribute(RecoveryConfiguration.RECOVERY_INFO_CACHE_NAME).set(recoveryInfoName);
        return this;
    }

    @Override
    public void validate() {
        if (!this.attributes.attribute(RecoveryConfiguration.ENABLED).get().booleanValue() || this.transaction().useSynchronization()) {
            return;
        }
        if (!this.clustering().cacheMode().isSynchronous()) {
            throw new CacheConfigurationException("Recovery not supported with Asynchronous " + this.clustering().cacheMode().friendlyCacheModeString() + " cache mode.");
        }
        if (!this.transaction().syncCommitPhase()) {
            throw new CacheConfigurationException("Recovery not supported with asynchronous commit phase.");
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public RecoveryConfiguration create() {
        return new RecoveryConfiguration(this.attributes.protect());
    }

    public RecoveryConfigurationBuilder read(RecoveryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "RecoveryConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

