/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.BaseQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.CacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.DistributedQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.QueueingAllSegmentListener;
import org.infinispan.notifications.cachelistener.QueueingSegmentListener;
import org.infinispan.notifications.cachelistener.SecurityActions;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.PartitionStatusChanged;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerRemoveCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterAsConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterAsKeyValueFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterAsKeyValueFilterConverter;
import org.infinispan.notifications.cachelistener.filter.DelegatingCacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.FilterIndexingServiceProvider;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.notifications.cachelistener.filter.KeyFilterAsCacheEventFilter;
import org.infinispan.notifications.impl.AbstractListenerImpl;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class CacheNotifierImpl<K, V>
extends AbstractListenerImpl<Event<K, V>, CacheEntryListenerInvocation<K, V>>
implements ClusterCacheNotifier<K, V> {
    private static final Log log = LogFactory.getLog(CacheNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(16);
    private static final Map<Class<? extends Annotation>, Class<?>> clusterAllowedListeners = new HashMap(4);
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryCreatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryRemovedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryVisitedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryModifiedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryActivatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryPassivatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryLoadedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryInvalidatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntriesEvictedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> transactionRegisteredListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> transactionCompletedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> dataRehashedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> topologyChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> partitionChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryEvictedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    private Cache<K, V> cache;
    private ClusteringDependentLogic clusteringDependentLogic;
    private TransactionManager transactionManager;
    private DistributedExecutorService distExecutorService;
    private Configuration config;
    private DistributionManager distributionManager;
    private EntryRetriever<K, V> entryRetriever;
    private InternalEntryFactory entryFactory;
    private ClusterEventManager<K, V> eventManager;
    private ComponentRegistry componentRegistry;
    private final Map<Object, UUID> clusterListenerIDs = new ConcurrentHashMap<Object, UUID>();
    private Set<FilterIndexingServiceProvider> filterIndexingServiceProviders;
    private final ConcurrentMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>> segmentHandler;

    public CacheNotifierImpl() {
        this(new ConcurrentHashMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>>());
    }

    CacheNotifierImpl(ConcurrentMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>> handler) {
        this.segmentHandler = handler;
        this.listenersMap.put(CacheEntryCreated.class, this.cacheEntryCreatedListeners);
        this.listenersMap.put(CacheEntryRemoved.class, this.cacheEntryRemovedListeners);
        this.listenersMap.put(CacheEntryVisited.class, this.cacheEntryVisitedListeners);
        this.listenersMap.put(CacheEntryModified.class, this.cacheEntryModifiedListeners);
        this.listenersMap.put(CacheEntryActivated.class, this.cacheEntryActivatedListeners);
        this.listenersMap.put(CacheEntryPassivated.class, this.cacheEntryPassivatedListeners);
        this.listenersMap.put(CacheEntryLoaded.class, this.cacheEntryLoadedListeners);
        this.listenersMap.put(CacheEntriesEvicted.class, this.cacheEntriesEvictedListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(CacheEntryInvalidated.class, this.cacheEntryInvalidatedListeners);
        this.listenersMap.put(DataRehashed.class, this.dataRehashedListeners);
        this.listenersMap.put(TopologyChanged.class, this.topologyChangedListeners);
        this.listenersMap.put(PartitionStatusChanged.class, this.partitionChangedListeners);
        this.listenersMap.put(CacheEntryEvicted.class, this.cacheEntryEvictedListeners);
    }

    @Inject
    void injectDependencies(Cache<K, V> cache, ClusteringDependentLogic clusteringDependentLogic, TransactionManager transactionManager, Configuration config, DistributionManager distributionManager, EntryRetriever<K, V> entryRetriever, InternalEntryFactory entryFactory, ClusterEventManager<K, V> eventManager) {
        this.cache = cache;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.transactionManager = transactionManager;
        this.config = config;
        this.distributionManager = distributionManager;
        this.entryRetriever = entryRetriever;
        this.entryFactory = entryFactory;
        this.eventManager = eventManager;
    }

    @Override
    public void start() {
        super.start();
        this.distExecutorService = SecurityActions.getDefaultExecutorService(this.cache);
        this.componentRegistry = this.cache.getAdvancedCache().getComponentRegistry();
        if (this.filterIndexingServiceProviders == null) {
            this.filterIndexingServiceProviders = ServiceFinder.load(FilterIndexingServiceProvider.class, new ClassLoader[0]);
            for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
                this.componentRegistry.wireDependencies(provider);
                provider.start();
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.filterIndexingServiceProviders != null) {
            for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
                provider.stop();
            }
            this.filterIndexingServiceProviders = null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener l) {
        if (l.clustered()) {
            return clusterAllowedListeners;
        }
        return allowedListeners;
    }

    @Override
    protected final Transaction suspendIfNeeded() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 6: {
                    return null;
                }
            }
            return this.transactionManager.suspend();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("An error occurred while trying to suspend a transaction.", e);
            }
            return null;
        }
    }

    @Override
    protected final void resumeIfNeeded(Transaction transaction) {
        block3: {
            if (transaction == null || this.transactionManager == null) {
                return;
            }
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.tracef((Throwable)e, "An error occurred while trying to resume a suspended transaction. tx=%s", (Object)transaction);
            }
        }
    }

    @Override
    public void notifyCacheEntryCreated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (!this.cacheEntryCreatedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_CREATED);
            this.configureEvent(e, key, value, pre, ctx, command, null, null);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryCreatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
            if (!ctx.isInTxScope()) {
                this.eventManager.sendEvents();
            }
        }
    }

    @Override
    public void notifyCacheEntryModified(K key, V value, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (!this.cacheEntryModifiedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_MODIFIED);
            this.configureEvent(e, key, value, pre, ctx, command, previousValue, previousMetadata);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryModifiedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
            if (!ctx.isInTxScope()) {
                this.eventManager.sendEvents();
            }
        }
    }

    @Override
    public void notifyCacheEntryRemoved(K key, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryRemovedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_REMOVED);
            this.configureEvent(e, key, null, pre, ctx, command, previousValue, previousMetadata);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryRemovedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
            if (!ctx.isInTxScope()) {
                this.eventManager.sendEvents();
            }
        }
    }

    private void configureEvent(EventImpl<K, V> e, K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command, V previousValue, Metadata previousMetadata) {
        Set<Flag> flags;
        e.setOriginLocal(ctx.isOriginLocal());
        e.setValue(pre ? previousValue : value);
        e.setPre(pre);
        e.setOldValue(previousValue);
        e.setOldMetadata(previousMetadata);
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry != null) {
            e.setMetadata(entry.getMetadata());
        } else if (command instanceof ClearCommand) {
            e.setMetadata(previousMetadata);
        }
        if (command != null && (flags = command.getFlags()) != null && flags.contains((Object)Flag.COMMAND_RETRY)) {
            e.setCommandRetried(true);
        }
        e.setKey(key);
        this.setTx(ctx, e);
    }

    @Override
    public void notifyCacheEntryVisited(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryVisitedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_VISITED);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryVisitedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntriesEvicted(Collection<InternalCacheEntry<? extends K, ? extends V>> entries, InvocationContext ctx, FlagAffectedCommand command) {
        if (!entries.isEmpty()) {
            if (this.isNotificationAllowed(command, this.cacheEntriesEvictedListeners)) {
                EventImpl e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
                Map evictedKeysAndValues = InfinispanCollections.transformCollectionToMap(entries, new InfinispanCollections.MapMakerFunction<K, V, InternalCacheEntry<? extends K, ? extends V>>(){

                    @Override
                    public Map.Entry<K, V> transform(final InternalCacheEntry<? extends K, ? extends V> input) {
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return input.getKey();
                            }

                            @Override
                            public V getValue() {
                                return input.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                });
                e.setEntries(evictedKeysAndValues);
                for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntriesEvictedListeners) {
                    listener.invoke(e);
                }
            }
            if (this.isNotificationAllowed(command, this.cacheEntryEvictedListeners)) {
                for (InternalCacheEntry<K, V> ice : entries) {
                    EventImpl e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
                    e.setKey(ice.getKey());
                    e.setValue(ice.getValue());
                    boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(ice.getKey());
                    for (CacheEntryListenerInvocation listener : this.cacheEntryEvictedListeners) {
                        listener.invoke(e, isLocalNodePrimaryOwner);
                    }
                }
            }
        }
    }

    @Override
    public void notifyCacheEntryEvicted(K key, V value, InvocationContext ctx, FlagAffectedCommand command) {
        EventImpl<K, V> e;
        boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
        if (this.isNotificationAllowed(command, this.cacheEntriesEvictedListeners)) {
            e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
            Map<K, V> map = Collections.singletonMap(key, value);
            e.setEntries(map);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntriesEvictedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
        if (this.isNotificationAllowed(command, this.cacheEntryEvictedListeners)) {
            e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
            e.setKey(key);
            e.setValue(value);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryEvictedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryInvalidated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryInvalidatedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_INVALIDATED);
            this.configureEvent(e, key, value, pre, ctx, command, value, null);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryInvalidatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryLoaded(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryLoadedListeners)) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_LOADED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryLoadedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryActivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryActivatedListeners)) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_ACTIVATED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryActivatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    private void setTx(InvocationContext ctx, EventImpl<K, V> e) {
        if (ctx != null && ctx.isInTxScope()) {
            GlobalTransaction tx = ((TxInvocationContext)ctx).getGlobalTransaction();
            e.setTransactionId(tx);
        }
    }

    @Override
    public void notifyCacheEntryPassivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryPassivatedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_PASSIVATED);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            boolean isLocalNodePrimaryOwner = this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryPassivatedListeners) {
                listener.invoke(e, isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.TRANSACTION_COMPLETED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(transaction);
            e.setTransactionSuccessful(successful);
            for (CacheEntryListenerInvocation<K, V> listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
            if (ctx.isInTxScope()) {
                if (successful) {
                    this.eventManager.sendEvents();
                } else {
                    this.eventManager.dropEvents();
                }
            }
        }
    }

    @Override
    public void notifyTransactionRegistered(GlobalTransaction globalTransaction, boolean isOriginLocal) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.TRANSACTION_REGISTERED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(globalTransaction);
            for (CacheEntryListenerInvocation<K, V> listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyDataRehashed(ConsistentHash readCH, ConsistentHash writeCH, ConsistentHash unionCH, int newTopologyId, boolean pre) {
        if (!this.dataRehashedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.DATA_REHASHED);
            e.setPre(pre);
            e.setConsistentHashAtStart(readCH);
            e.setConsistentHashAtEnd(writeCH);
            e.setUnionConsistentHash(unionCH);
            e.setNewTopologyId(newTopologyId);
            for (CacheEntryListenerInvocation<K, V> listener : this.dataRehashedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTopologyChanged(CacheTopology oldTopology, CacheTopology newTopology, int newTopologyId, boolean pre) {
        if (!this.topologyChangedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.TOPOLOGY_CHANGED);
            e.setPre(pre);
            if (oldTopology != null) {
                e.setConsistentHashAtStart(oldTopology.getReadConsistentHash());
            }
            e.setConsistentHashAtEnd(newTopology.getWriteConsistentHash());
            e.setNewTopologyId(newTopologyId);
            for (CacheEntryListenerInvocation<K, V> listener : this.topologyChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyPartitionStatusChanged(AvailabilityMode mode, boolean pre) {
        if (!this.partitionChangedListeners.isEmpty()) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache, Event.Type.PARTITION_STATUS_CHANGED);
            e.setPre(pre);
            e.setAvailabilityMode(mode);
            for (CacheEntryListenerInvocation<K, V> listener : this.partitionChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyClusterListeners(Collection<? extends CacheEntryEvent<K, V>> events, UUID uuid) {
        block5: for (CacheEntryEvent<K, V> event : events) {
            if (event.isPre()) {
                throw new IllegalArgumentException("Events for cluster listener should never be pre change");
            }
            switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: {
                    for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryModifiedListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        listener.invokeNoChecks(event, false, true);
                    }
                    continue block5;
                }
                case CACHE_ENTRY_CREATED: {
                    for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryCreatedListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        listener.invokeNoChecks(event, false, true);
                    }
                    continue block5;
                }
                case CACHE_ENTRY_REMOVED: {
                    for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntryRemovedListeners) {
                        if (!listener.isClustered() || !uuid.equals(listener.getIdentifier())) continue;
                        listener.invokeNoChecks(event, false, true);
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected event type encountered!");
                }
            }
        }
    }

    @Override
    public Collection<DistributedCallable> retrieveClusterListenerCallablesToInstall() {
        HashSet<Object> enlistedAlready = new HashSet<Object>();
        HashSet<DistributedCallable> callables = new HashSet<DistributedCallable>();
        if (log.isTraceEnabled()) {
            log.tracef("Request received to get cluster listeners currently registered", new Object[0]);
        }
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryModifiedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryCreatedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryRemovedListeners);
        if (log.isTraceEnabled()) {
            log.tracef("Cluster listeners found %s", (Object)callables);
        }
        return callables;
    }

    private void registerClusterListenerCallablesToInstall(Set<Object> enlistedAlready, Set<DistributedCallable> callables, List<CacheEntryListenerInvocation<K, V>> listenerInvocations) {
        for (CacheEntryListenerInvocation<K, V> listener : listenerInvocations) {
            if (enlistedAlready.contains(listener.getTarget())) continue;
            if (listener.isClustered()) {
                callables.add(new ClusterListenerReplicateCallable<K, V>(listener.getIdentifier(), this.cache.getCacheManager().getAddress(), listener.getFilter(), listener.getConverter(), listener.isSync()));
                enlistedAlready.add(listener.getTarget());
                continue;
            }
            if (!(listener.getTarget() instanceof RemoteClusterListener)) continue;
            RemoteClusterListener lcl = (RemoteClusterListener)listener.getTarget();
            callables.add(new ClusterListenerReplicateCallable<K, V>(lcl.getId(), lcl.getOwnerAddress(), listener.getFilter(), listener.getConverter(), listener.isSync()));
            enlistedAlready.add(listener.getTarget());
        }
    }

    public boolean isNotificationAllowed(FlagAffectedCommand cmd, List<CacheEntryListenerInvocation<K, V>> listeners) {
        return (cmd == null || !cmd.hasFlag(Flag.SKIP_LISTENER_NOTIFICATION)) && !listeners.isEmpty();
    }

    @Override
    public void addListener(Object listener) {
        this.addListener(listener, null, null, null);
    }

    @Override
    public void addListener(Object listener, ClassLoader classLoader) {
        this.addListener(listener, null, null, classLoader);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter, ClassLoader classLoader) {
        this.addListener(listener, new KeyFilterAsCacheEventFilter<K>(filter), null, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        QueueingSegmentListener handler;
        IndexedFilter indexedFilter;
        Listener l = CacheNotifierImpl.testListenerClassValidity(listener.getClass());
        UUID generatedId = UUID.randomUUID();
        CacheMode cacheMode = this.config.clustering().cacheMode();
        FilterIndexingServiceProvider indexingProvider = null;
        boolean foundMethods = false;
        if (filter instanceof IndexedFilter && (indexingProvider = this.findIndexingServiceProvider(indexedFilter = (IndexedFilter)filter)) != null) {
            DelegatingCacheInvocationBuilder builder = new DelegatingCacheInvocationBuilder(indexingProvider);
            builder.setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? cacheMode.isDistributed() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setConverter(converter).setIdentifier(generatedId).setClassLoader(classLoader);
            foundMethods = this.validateAndAddListenerInvocations(listener, builder);
            builder.registerListenerInvocations();
        }
        if (indexingProvider == null) {
            CacheInvocationBuilder builder = new CacheInvocationBuilder();
            builder.setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? cacheMode.isDistributed() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setConverter(converter).setIdentifier(generatedId).setClassLoader(classLoader);
            foundMethods = this.validateAndAddListenerInvocations(listener, builder);
        }
        if (foundMethods && l.clustered()) {
            if (l.observation() == Listener.Observation.PRE) {
                throw log.clusterListenerRegisteredWithOnlyPreEvents(listener.getClass());
            }
            if (cacheMode.isInvalidation()) {
                throw new UnsupportedOperationException("Cluster listeners cannot be used with Invalidation Caches!");
            }
            if (cacheMode.isDistributed()) {
                this.clusterListenerIDs.put(listener, generatedId);
                EmbeddedCacheManager manager = this.cache.getCacheManager();
                Address ourAddress = manager.getAddress();
                List<Address> members = manager.getMembers();
                if (members != null && members.size() > 1) {
                    int n;
                    void var15_17;
                    DistributedExecutionCompletionService<Void> decs = new DistributedExecutionCompletionService<Void>(this.distExecutorService);
                    if (log.isTraceEnabled()) {
                        log.tracef("Replicating cluster listener to other nodes %s for cluster listener with id %s", (Object)members, (Object)generatedId);
                    }
                    ClusterListenerReplicateCallable<? super K, ? super V> callable = new ClusterListenerReplicateCallable<K, V>(generatedId, ourAddress, filter, converter, l.sync());
                    for (Address member : members) {
                        if (member.equals(ourAddress)) continue;
                        decs.submit(member, callable);
                    }
                    boolean bl = false;
                    while (var15_17 < members.size() - 1) {
                        try {
                            decs.take().get();
                        }
                        catch (InterruptedException e) {
                            throw new CacheListenerException(e);
                        }
                        catch (ExecutionException e) {
                            throw new CacheListenerException(e);
                        }
                        ++var15_17;
                    }
                    boolean bl2 = false;
                    List<Address> membersAfter = manager.getMembers();
                    for (Address member : membersAfter) {
                        if (members.contains(member) || member.equals(ourAddress)) continue;
                        if (log.isTraceEnabled()) {
                            log.tracef("Found additional node %s that joined during replication of cluster listener with id %s", (Object)member, (Object)generatedId);
                        }
                        ++n;
                        decs.submit(member, callable);
                    }
                    for (int i = 0; i < n; ++i) {
                        try {
                            decs.take().get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new CacheListenerException(e);
                        }
                        catch (ExecutionException e) {
                            throw new CacheListenerException(e);
                        }
                    }
                }
            }
        }
        if ((handler = (QueueingSegmentListener)this.segmentHandler.remove(generatedId)) != null) {
            CacheEventConverterAsConverter<? super K, ? super V, C> usedConverter;
            KeyValueFilter<Object, Object> usedFilter;
            if (log.isTraceEnabled()) {
                log.tracef("Listener %s requests initial state for cache", (Object)generatedId);
            }
            if (filter instanceof CacheEventFilterConverter && (filter == converter || converter == null)) {
                usedFilter = new CacheEventFilterConverterAsKeyValueFilterConverter((CacheEventFilterConverter)filter);
                usedConverter = null;
            } else {
                usedFilter = filter == null ? null : new CacheEventFilterAsKeyValueFilter<K, V>(filter);
                usedConverter = converter == null ? null : new CacheEventConverterAsConverter<K, V, C>(converter);
            }
            CloseableIterator<CacheEntry<K, C>> iterator = this.entryRetriever.retrieveEntries(usedFilter, usedConverter, null, handler);
            Object object = null;
            try {
                while (iterator.hasNext()) {
                    CacheEntry cacheEntry = (CacheEntry)iterator.next();
                    Object value = handler.markKeyAsProcessing(cacheEntry.getKey());
                    if (value == BaseQueueingSegmentListener.REMOVED) continue;
                    this.raiseEventForInitialTransfer(generatedId, cacheEntry, l.clustered());
                    handler.notifiedKey(cacheEntry.getKey());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (iterator != null) {
                    if (object != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
            Set entries = handler.findCreatedEntries();
            for (CacheEntry cacheEntry : entries) {
                this.raiseEventForInitialTransfer(generatedId, cacheEntry, l.clustered());
            }
            if (log.isTraceEnabled()) {
                log.tracef("Listener %s initial state for cache completed", (Object)generatedId);
            }
            handler.transferComplete();
        }
    }

    private FilterIndexingServiceProvider findIndexingServiceProvider(IndexedFilter indexedFilter) {
        for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
            if (!provider.supportsFilter(indexedFilter)) continue;
            return provider;
        }
        log.noFilterIndexingServiceProviderFound(indexedFilter.getClass().getName());
        return null;
    }

    @Override
    public List<CacheEntryListenerInvocation<K, V>> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        return super.getListenerCollectionForAnnotation(annotation);
    }

    private void raiseEventForInitialTransfer(UUID identifier, CacheEntry entry, boolean clustered) {
        EventImpl preEvent;
        if (clustered) {
            preEvent = null;
        } else {
            preEvent = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_CREATED);
            preEvent.setKey(entry.getKey());
            preEvent.setPre(true);
        }
        EventImpl postEvent = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_CREATED);
        postEvent.setKey(entry.getKey());
        postEvent.setValue(entry.getValue());
        postEvent.setMetadata(entry.getMetadata());
        postEvent.setPre(false);
        for (CacheEntryListenerInvocation invocation : this.cacheEntryCreatedListeners) {
            if (invocation.getIdentifier() != identifier) continue;
            if (preEvent != null) {
                invocation.invokeNoChecks(preEvent, true, true);
            }
            invocation.invokeNoChecks(postEvent, true, true);
        }
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.addListener(listener, filter, null);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.addListener(listener, filter, converter, null);
    }

    @Override
    public void removeListener(Object listener) {
        super.removeListener(listener);
        UUID id = this.clusterListenerIDs.remove(listener);
        if (id != null) {
            List<Future<Void>> futures = this.distExecutorService.submitEverywhere(new ClusterListenerRemoveCallable(id));
            for (Future<Void> future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new CacheListenerException(e);
                }
                catch (ExecutionException e) {
                    throw new CacheListenerException(e);
                }
            }
        }
    }

    @Override
    protected Set<CacheEntryListenerInvocation<K, V>> removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        Set<CacheEntryListenerInvocation<K, V>> markedForRemoval = super.removeListenerInvocation(annotation, listener);
        for (CacheEntryListenerInvocation cacheEntryListenerInvocation : markedForRemoval) {
            if (!(cacheEntryListenerInvocation instanceof DelegatingCacheEntryListenerInvocation)) continue;
            ((DelegatingCacheEntryListenerInvocation)cacheEntryListenerInvocation).unregister();
        }
        return markedForRemoval;
    }

    static {
        allowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        allowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        allowedListeners.put(CacheEntryVisited.class, CacheEntryVisitedEvent.class);
        allowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        allowedListeners.put(CacheEntryActivated.class, CacheEntryActivatedEvent.class);
        allowedListeners.put(CacheEntryPassivated.class, CacheEntryPassivatedEvent.class);
        allowedListeners.put(CacheEntryLoaded.class, CacheEntryLoadedEvent.class);
        allowedListeners.put(CacheEntriesEvicted.class, CacheEntriesEvictedEvent.class);
        allowedListeners.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        allowedListeners.put(TransactionCompleted.class, TransactionCompletedEvent.class);
        allowedListeners.put(CacheEntryInvalidated.class, CacheEntryInvalidatedEvent.class);
        allowedListeners.put(DataRehashed.class, DataRehashedEvent.class);
        allowedListeners.put(TopologyChanged.class, TopologyChangedEvent.class);
        allowedListeners.put(PartitionStatusChanged.class, PartitionStatusChangedEvent.class);
        allowedListeners.put(CacheEntryEvicted.class, CacheEntryEvictedEvent.class);
        clusterAllowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        clusterAllowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        clusterAllowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
    }

    protected static class BaseCacheEntryListenerInvocation<K, V>
    implements CacheEntryListenerInvocation<K, V> {
        protected final ListenerInvocation<Event<K, V>> invocation;
        protected final CacheEventFilter<? super K, ? super V> filter;
        protected final CacheEventConverter<? super K, ? super V, ?> converter;
        protected final boolean onlyPrimary;
        protected final boolean clustered;
        protected final UUID identifier;
        protected final Class<? extends Annotation> annotation;
        protected final boolean sync;
        protected final boolean filterAndConvert;
        protected final Listener.Observation observation;

        protected BaseCacheEntryListenerInvocation(ListenerInvocation<Event<K, V>> invocation, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, boolean clustered, UUID identifier, boolean sync, Listener.Observation observation) {
            this.invocation = invocation;
            this.filter = filter;
            this.converter = converter;
            this.filterAndConvert = filter instanceof CacheEventFilterConverter && (filter == converter || converter == null);
            this.onlyPrimary = onlyPrimary;
            this.clustered = clustered;
            this.identifier = identifier;
            this.annotation = annotation;
            this.sync = sync;
            this.observation = observation;
        }

        @Override
        public void invoke(Event<K, V> event) {
            this.doRealInvocation(event);
        }

        @Override
        public void invoke(CacheEntryEvent<K, V> event, boolean isLocalNodePrimaryOwner) {
            CacheEntryEvent<K, V> resultingEvent = this.shouldInvoke(event, isLocalNodePrimaryOwner);
            if (resultingEvent != null) {
                this.invokeNoChecks(resultingEvent, false, this.filterAndConvert);
            }
        }

        @Override
        public void invokeNoChecks(CacheEntryEvent<K, V> event, boolean skipQueue, boolean skipConverter) {
            CacheEntryEvent<Object, Object> eventToUse = !skipConverter ? this.convertValue(this.converter, event) : event;
            if (skipQueue) {
                this.invocation.invoke(eventToUse);
            } else {
                this.doRealInvocation(eventToUse);
            }
        }

        protected void doRealInvocation(Event<K, V> event) {
            this.invocation.invoke(event);
        }

        protected CacheEntryEvent<K, V> shouldInvoke(CacheEntryEvent<K, V> event, boolean isLocalNodePrimaryOwner) {
            if (this.onlyPrimary && !isLocalNodePrimaryOwner) {
                return null;
            }
            if (event instanceof EventImpl) {
                EventType eventType;
                EventImpl eventImpl = (EventImpl)event;
                boolean isPre = eventImpl.isPre();
                if (!this.observation.shouldInvoke(isPre)) {
                    return null;
                }
                if (this.filter != null && (eventType = this.getEvent(eventImpl)) != null) {
                    if (this.filterAndConvert) {
                        Object newValue = ((CacheEventFilterConverter)this.filter).filterAndConvert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), eventType);
                        if (newValue != null) {
                            Object clone = eventImpl.clone();
                            ((EventImpl)clone).setValue(newValue);
                            return clone;
                        }
                        return null;
                    }
                    if (!this.filter.accept(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), eventType)) {
                        return null;
                    }
                }
            }
            return event;
        }

        private EventType getEvent(EventImpl<K, V> event) {
            switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: 
                case CACHE_ENTRY_CREATED: 
                case CACHE_ENTRY_REMOVED: 
                case CACHE_ENTRY_ACTIVATED: 
                case CACHE_ENTRY_INVALIDATED: 
                case CACHE_ENTRY_LOADED: 
                case CACHE_ENTRY_PASSIVATED: 
                case CACHE_ENTRY_VISITED: {
                    return new EventType(event.isCommandRetried(), event.isPre(), event.getType());
                }
            }
            return null;
        }

        @Override
        public Object getTarget() {
            return this.invocation.getTarget();
        }

        @Override
        public CacheEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        @Override
        public CacheEventConverter<? super K, ? super V, ?> getConverter() {
            return this.converter;
        }

        @Override
        public boolean isClustered() {
            return this.clustered;
        }

        @Override
        public UUID getIdentifier() {
            return this.identifier;
        }

        @Override
        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected CacheEntryEvent<K, V> convertValue(CacheEventConverter<? super K, ? super V, ?> converter, CacheEntryEvent<K, V> event) {
            if (converter == null) return event;
            if (!(event instanceof EventImpl)) throw new IllegalArgumentException("Provided event should be org.infinispan.notifications.cachelistener.event.impl.EventImpl when a converter is being used!");
            EventImpl eventImpl = event;
            Object newValue = converter.convert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), null);
            if (newValue == eventImpl.getValue()) return eventImpl;
            Object clone = eventImpl.clone();
            ((EventImpl)clone).setValue(newValue);
            return clone;
        }

        @Override
        public boolean isSync() {
            return this.sync;
        }
    }

    protected static class ClusteredListenerInvocation<K, V>
    extends BaseCacheEntryListenerInvocation<K, V> {
        private final QueueingSegmentListener<K, V, CacheEntryEvent<K, V>> handler;

        public ClusteredListenerInvocation(ListenerInvocation<Event<K, V>> invocation, QueueingSegmentListener<K, V, CacheEntryEvent<K, V>> handler, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, UUID identifier, boolean sync, Listener.Observation observation) {
            super(invocation, filter, converter, annotation, onlyPrimary, true, identifier, sync, observation);
            this.handler = handler;
        }

        @Override
        public void invoke(Event<K, V> event) {
            throw new UnsupportedOperationException("Clustered initial transfer don't support regular events!");
        }

        @Override
        protected void doRealInvocation(Event<K, V> event) {
            if (!this.handler.handleEvent((CacheEntryEvent)event, this.invocation)) {
                super.doRealInvocation(event);
            }
        }
    }

    protected class NonClusteredListenerInvocation
    extends BaseCacheEntryListenerInvocation<K, V> {
        private final QueueingSegmentListener<K, V, Event<K, V>> handler;

        protected NonClusteredListenerInvocation(ListenerInvocation<Event<K, V>> invocation, QueueingSegmentListener<K, V, Event<K, V>> handler, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, UUID identifier, boolean sync, Listener.Observation observation) {
            super(invocation, filter, converter, annotation, onlyPrimary, false, identifier, sync, observation);
            this.handler = handler;
        }

        @Override
        protected void doRealInvocation(Event<K, V> event) {
            if (!this.handler.handleEvent(event, this.invocation)) {
                super.doRealInvocation(event);
            }
        }
    }

    protected class DelegatingCacheInvocationBuilder
    extends CacheInvocationBuilder {
        private final FilterIndexingServiceProvider provider;
        private final Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners;

        DelegatingCacheInvocationBuilder(FilterIndexingServiceProvider provider) {
            this.listeners = new HashMap(3);
            this.provider = provider;
        }

        @Override
        public DelegatingCacheEntryListenerInvocation<K, V> build() {
            DelegatingCacheEntryListenerInvocation invocation = this.provider.interceptListenerInvocation(super.build());
            List invocations = this.listeners.get(invocation.getAnnotation());
            if (invocations == null) {
                invocations = new ArrayList(2);
                this.listeners.put(invocation.getAnnotation(), invocations);
            }
            invocations.add(invocation);
            return invocation;
        }

        void registerListenerInvocations() {
            if (!this.listeners.isEmpty()) {
                boolean filterAndConvert = this.filter == this.converter || this.converter == null;
                this.provider.registerListenerInvocations(this.clustered, this.onlyPrimary, filterAndConvert, (IndexedFilter)this.filter, this.listeners);
            }
        }
    }

    protected class CacheInvocationBuilder
    extends AbstractListenerImpl.AbstractInvocationBuilder {
        CacheEventFilter<? super K, ? super V> filter;
        CacheEventConverter<? super K, ? super V, ?> converter;
        boolean onlyPrimary;
        boolean clustered;
        boolean includeCurrentState;
        UUID identifier;
        Listener.Observation observation;

        protected CacheInvocationBuilder() {
            super(CacheNotifierImpl.this);
        }

        public CacheEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        public CacheInvocationBuilder setFilter(CacheEventFilter<? super K, ? super V> filter) {
            this.filter = filter;
            return this;
        }

        public CacheEventConverter<? super K, ? super V, ?> getConverter() {
            return this.converter;
        }

        public CacheInvocationBuilder setConverter(CacheEventConverter<? super K, ? super V, ?> converter) {
            this.converter = converter;
            return this;
        }

        public boolean isOnlyPrimary() {
            return this.onlyPrimary;
        }

        public CacheInvocationBuilder setOnlyPrimary(boolean onlyPrimary) {
            this.onlyPrimary = onlyPrimary;
            return this;
        }

        public boolean isClustered() {
            return this.clustered;
        }

        public CacheInvocationBuilder setClustered(boolean clustered) {
            this.clustered = clustered;
            return this;
        }

        public UUID getIdentifier() {
            return this.identifier;
        }

        public CacheInvocationBuilder setIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public boolean isIncludeCurrentState() {
            return this.includeCurrentState;
        }

        public CacheInvocationBuilder setIncludeCurrentState(boolean includeCurrentState) {
            this.includeCurrentState = includeCurrentState;
            return this;
        }

        public Listener.Observation getObservation() {
            return this.observation;
        }

        public CacheInvocationBuilder setObservation(Listener.Observation observation) {
            this.observation = observation;
            return this;
        }

        public CacheEntryListenerInvocation<K, V> build() {
            BaseCacheEntryListenerInvocation returnValue;
            AbstractListenerImpl.ListenerInvocationImpl invocation = new AbstractListenerImpl.ListenerInvocationImpl(CacheNotifierImpl.this, this.target, this.method, this.sync, this.classLoader, this.subject);
            this.wireFilterAndConverterDependencies(this.filter, this.converter);
            if (this.includeCurrentState) {
                if (this.clustered) {
                    QueueingSegmentListener handler = (QueueingAllSegmentListener)CacheNotifierImpl.this.segmentHandler.get(this.identifier);
                    if (handler == null) {
                        handler = CacheNotifierImpl.this.config.clustering().cacheMode().isDistributed() ? new DistributedQueueingSegmentListener(CacheNotifierImpl.this.entryFactory, CacheNotifierImpl.this.distributionManager) : new QueueingAllSegmentListener(CacheNotifierImpl.this.entryFactory);
                        QueueingSegmentListener currentQueue = CacheNotifierImpl.this.segmentHandler.putIfAbsent(this.identifier, handler);
                        if (currentQueue != null) {
                            handler = currentQueue;
                        }
                    }
                    returnValue = new ClusteredListenerInvocation(invocation, handler, this.filter, this.converter, this.annotation, this.onlyPrimary, this.identifier, this.sync, this.observation);
                } else {
                    returnValue = new BaseCacheEntryListenerInvocation(invocation, this.filter, this.converter, this.annotation, this.onlyPrimary, this.clustered, this.identifier, this.sync, this.observation);
                }
            } else {
                returnValue = new BaseCacheEntryListenerInvocation(invocation, this.filter, this.converter, this.annotation, this.onlyPrimary, this.clustered, this.identifier, this.sync, this.observation);
            }
            return returnValue;
        }

        private <C> void wireFilterAndConverterDependencies(CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
            if (filter != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(filter);
            }
            if (converter != null && converter != filter) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(converter);
            }
        }
    }
}

