/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.Map;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedDistributionInterceptor
extends TxDistributionInterceptor {
    private static final Log log = LogFactory.getLog(VersionedDistributionInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareOnAffectedNodes(TxInvocationContext<?> ctx, PrepareCommand command, Collection<Address> recipients, boolean ignored) {
        try {
            RpcOptions rpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build();
            Map<Address, Response> resps = this.rpcManager.invokeRemotely(recipients, command, rpcOptions);
            this.checkTxCommandResponses(resps, command);
            Object ct = ctx.getCacheTransaction();
            for (Response r : resps.values()) {
                WriteSkewHelper.readVersionsFromResponse(r, ct);
            }
        }
        finally {
            VersionedDistributionInterceptor.transactionRemotelyPrepared(ctx);
        }
    }
}

