/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheTransaction
implements CacheTransaction {
    protected final GlobalTransaction tx;
    private static Log log = LogFactory.getLog(AbstractCacheTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int INITIAL_LOCK_CAPACITY = 4;
    protected volatile boolean hasLocalOnlyModifications;
    protected volatile List<WriteCommand> modifications;
    protected Map<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> affectedKeys = null;
    protected volatile Set<Object> lockedKeys = null;
    protected volatile Set<Object> backupKeyLocks = null;
    private boolean txComplete = false;
    private volatile boolean needToNotifyWaiters = false;
    protected final int topologyId;
    private EntryVersionsMap updatedEntryVersions;
    private EntryVersionsMap versionsSeenMap;
    private Map<Object, EntryVersion> lookedUpRemoteVersions;
    private volatile boolean isMarkedForRollback;
    private final long txCreationTime;
    private final Object lockReleaseNotifier = new Object();
    protected final Equivalence<Object> keyEquivalence;
    private volatile Flag stateTransferFlag;

    @Override
    public final boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    @Override
    public void markForRollback(boolean markForRollback) {
        this.isMarkedForRollback = markForRollback;
    }

    public AbstractCacheTransaction(GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence, long txCreationTime) {
        this.tx = tx;
        this.topologyId = topologyId;
        this.keyEquivalence = keyEquivalence;
        this.txCreationTime = txCreationTime;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public final List<WriteCommand> getModifications() {
        if (this.hasLocalOnlyModifications) {
            ArrayList<WriteCommand> mods = new ArrayList<WriteCommand>();
            for (WriteCommand cmd : this.modifications) {
                if (cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) continue;
                mods.add(cmd);
            }
            return mods;
        }
        return this.getAllModifications();
    }

    @Override
    public final List<WriteCommand> getAllModifications() {
        return this.modifications == null ? InfinispanCollections.emptyList() : this.modifications;
    }

    public final void setModifications(List<WriteCommand> modifications) {
        if (modifications == null) {
            throw new IllegalArgumentException("modification list cannot be null");
        }
        ArrayList<WriteCommand> mods = new ArrayList<WriteCommand>();
        for (WriteCommand cmd : modifications) {
            if (cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                this.hasLocalOnlyModifications = true;
            }
            mods.add(cmd);
        }
        this.modifications = Collections.synchronizedList(mods);
    }

    @Override
    public final boolean hasModification(Class<?> modificationClass) {
        if (this.modifications != null) {
            for (WriteCommand mod : this.getModifications()) {
                if (!modificationClass.isAssignableFrom(mod.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return this.lookedUpEntries.get(key);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public boolean ownsLock(Object key) {
        return this.getLockedKeys().contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnTransactionFinished() {
        if (trace) {
            log.tracef("Transaction %s has completed, notifying listening threads.", (Object)this.tx);
        }
        this.txComplete = true;
        if (this.needToNotifyWaiters) {
            Object object = this.lockReleaseNotifier;
            synchronized (object) {
                this.txComplete = true;
                this.lockReleaseNotifier.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForLockRelease(Object key, long lockAcquisitionTimeout) throws InterruptedException {
        if (this.txComplete) {
            return true;
        }
        boolean potentiallyLocked = this.hasLockOrIsLockBackup(key);
        if (trace) {
            log.tracef("Transaction gtx=%s potentially locks key %s? %s", (Object)this.tx, key, (Object)potentiallyLocked);
        }
        if (potentiallyLocked) {
            Object object = this.lockReleaseNotifier;
            synchronized (object) {
                this.needToNotifyWaiters = true;
                if (this.txComplete) {
                    this.needToNotifyWaiters = false;
                    return true;
                }
                this.lockReleaseNotifier.wait(lockAcquisitionTimeout);
                return this.txComplete;
            }
        }
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void addBackupLockForKey(Object key) {
        if (this.backupKeyLocks == null) {
            this.backupKeyLocks = Collections.synchronizedSet(new HashSet(4));
        }
        this.backupKeyLocks.add(key);
    }

    public void registerLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = Collections.synchronizedSet(CollectionFactory.makeSet(4, this.keyEquivalence));
        }
        if (trace) {
            log.tracef("Registering locked key: %s", (Object)Util.toStr(key));
        }
        this.lockedKeys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? InfinispanCollections.emptySet() : this.lockedKeys;
    }

    @Override
    public Set<Object> getBackupLockedKeys() {
        return this.backupKeyLocks == null ? InfinispanCollections.emptySet() : this.backupKeyLocks;
    }

    @Override
    public void clearLockedKeys() {
        if (trace) {
            log.tracef("Clearing locked keys: %s", (Object)Util.toStr(this.lockedKeys));
        }
        this.lockedKeys = null;
    }

    private boolean hasLockOrIsLockBackup(Object key) {
        Set<Object> lockedKeysCopy = this.lockedKeys;
        Set<Object> backupKeyLocksCopy = this.backupKeyLocks;
        return lockedKeysCopy != null && lockedKeysCopy.contains(key) || backupKeyLocksCopy != null && backupKeyLocksCopy.contains(key);
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys == null ? InfinispanCollections.emptySet() : this.affectedKeys;
    }

    public void addAffectedKey(Object key) {
        this.initAffectedKeys();
        this.affectedKeys.add(key);
    }

    public void addAllAffectedKeys(Collection<?> keys) {
        this.initAffectedKeys();
        this.affectedKeys.addAll(keys);
    }

    private void initAffectedKeys() {
        if (this.affectedKeys == null) {
            this.affectedKeys = CollectionFactory.makeSet(4, this.keyEquivalence);
        }
    }

    @Override
    public EntryVersionsMap getUpdatedEntryVersions() {
        return this.updatedEntryVersions;
    }

    @Override
    public void setUpdatedEntryVersions(EntryVersionsMap updatedEntryVersions) {
        this.updatedEntryVersions = updatedEntryVersions;
    }

    @Override
    public EntryVersion getLookedUpRemoteVersion(Object key) {
        return this.lookedUpRemoteVersions != null ? this.lookedUpRemoteVersions.get(key) : null;
    }

    @Override
    public void putLookedUpRemoteVersion(Object key, EntryVersion version) {
        if (this.lookedUpRemoteVersions == null) {
            this.lookedUpRemoteVersions = new HashMap<Object, EntryVersion>();
        }
        this.lookedUpRemoteVersions.put(key, version);
    }

    @Override
    public void addReadKey(Object key) {
    }

    @Override
    public boolean keyRead(Object key) {
        return false;
    }

    @Override
    public void addVersionRead(Object key, EntryVersion version) {
        if (version == null) {
            return;
        }
        if (this.versionsSeenMap == null) {
            this.versionsSeenMap = new EntryVersionsMap();
        }
        if (!this.versionsSeenMap.containsKey(key)) {
            if (log.isTraceEnabled()) {
                log.tracef("Transaction %s read %s with version %s", (Object)this.getGlobalTransaction().globalId(), key, (Object)version);
            }
            this.versionsSeenMap.put(key, (IncrementableEntryVersion)version);
        }
    }

    @Override
    public void replaceVersionRead(Object key, EntryVersion version) {
        if (version == null) {
            return;
        }
        if (this.versionsSeenMap == null) {
            this.versionsSeenMap = new EntryVersionsMap();
        }
        EntryVersion oldVersion = this.versionsSeenMap.put(key, (IncrementableEntryVersion)version);
        if (log.isTraceEnabled()) {
            log.tracef("Transaction %s replaced version for key %s. old=%s, new=%s", this.getGlobalTransaction().globalId(), key, oldVersion, version);
        }
    }

    @Override
    public EntryVersionsMap getVersionsRead() {
        return this.versionsSeenMap == null ? new EntryVersionsMap() : this.versionsSeenMap;
    }

    public final boolean isFromStateTransfer() {
        return this.stateTransferFlag != null;
    }

    public final Flag getStateTransferFlag() {
        return this.stateTransferFlag;
    }

    public abstract void setStateTransferFlag(Flag var1);

    protected final void internalSetStateTransferFlag(Flag stateTransferFlag) {
        this.stateTransferFlag = stateTransferFlag;
    }

    @Override
    public long getCreationTime() {
        return this.txCreationTime;
    }
}

