/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.commons.util.CloseableSpliterator;

public abstract class AbstractCloseableIteratorCollection<O, K, V>
extends AbstractCollection<O>
implements CloseableIteratorCollection<O> {
    protected final Cache<K, V> cache;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public AbstractCloseableIteratorCollection(Cache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public abstract CloseableIterator<O> iterator();

    @Override
    public abstract CloseableSpliterator<O> spliterator();

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        try (Iterator it = this.iterator();){
            for (int i = 0; i < r.length; ++i) {
                if (!it.hasNext()) {
                    Object[] objectArray = Arrays.copyOf(r, i);
                    return objectArray;
                }
                r[i] = it.next();
            }
            Object[] objectArray = it.hasNext() ? AbstractCloseableIteratorCollection.finishToArray(r, it) : r;
            return objectArray;
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        try (Iterator it = this.iterator();){
            for (int i = 0; i < r.length; ++i) {
                if (!it.hasNext()) {
                    if (a == r) {
                        r[i] = null;
                    } else {
                        if (a.length < i) {
                            T[] TArray = Arrays.copyOf(r, i);
                            return TArray;
                        }
                        System.arraycopy(r, 0, a, 0, i);
                        if (a.length > i) {
                            a[i] = null;
                        }
                    }
                    T[] TArray = a;
                    return TArray;
                }
                r[i] = it.next();
            }
            T[] TArray = it.hasNext() ? AbstractCloseableIteratorCollection.finishToArray(r, it) : r;
            return TArray;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        try (Iterator it = this.iterator();){
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    private static <T> T[] finishToArray(T[] r, Iterator<?> it) {
        int i = r.length;
        while (it.hasNext()) {
            int cap = r.length;
            if (i == cap) {
                int newCap = cap + (cap >> 1) + 1;
                if (newCap - 0x7FFFFFF7 > 0) {
                    newCap = AbstractCloseableIteratorCollection.hugeCapacity(cap + 1);
                }
                r = Arrays.copyOf(r, newCap);
            }
            r[i++] = it.next();
        }
        return i == r.length ? r : Arrays.copyOf(r, i);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError("Required array size too large");
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

