/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.configuration.parsing.XMLExtendedStreamReaderImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ParserRegistry
implements NamespaceMappingParser {
    private static final Log log = LogFactory.getLog(ParserRegistry.class);
    private final WeakReference<ClassLoader> cl;
    private final ConcurrentMap<QName, ConfigurationParser> parserMappings = CollectionFactory.makeConcurrentMap();

    public ParserRegistry() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ParserRegistry(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public ParserRegistry(ClassLoader classLoader, boolean defaultParsersOnly) {
        this.cl = new WeakReference<ClassLoader>(classLoader);
        Set<ConfigurationParser> parsers = ServiceFinder.load(ConfigurationParser.class, (ClassLoader)this.cl.get(), ParserRegistry.class.getClassLoader());
        for (ConfigurationParser parser : parsers) {
            try {
                Namespace[] namespaces = parser.getNamespaces();
                if (namespaces == null) {
                    throw log.parserDoesNotDeclareNamespaces(parser.getClass().getName());
                }
                boolean skipParser = defaultParsersOnly;
                if (skipParser) {
                    for (Namespace ns : namespaces) {
                        if (!"".equals(ns.uri())) continue;
                        skipParser = false;
                    }
                }
                if (skipParser) continue;
                for (Namespace ns : namespaces) {
                    QName qName = new QName(ns.uri(), ns.root());
                    if (this.parserMappings.putIfAbsent(qName, parser) == null) continue;
                    throw log.parserRootElementAlreadyRegistered(qName);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(String filename) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream is = fileLookup.lookupFile(filename, (ClassLoader)this.cl.get());
        if (is == null) {
            throw new FileNotFoundException(filename);
        }
        try {
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is);
            return configurationBuilderHolder;
        }
        finally {
            Util.close((Closeable)is);
        }
    }

    public ConfigurationBuilderHolder parse(InputStream is) {
        try {
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder((ClassLoader)this.cl.get());
            this.parse(is, holder);
            return holder;
        }
        catch (CacheConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    public void parse(InputStream is, ConfigurationBuilderHolder holder) throws XMLStreamException {
        BufferedInputStream input = new BufferedInputStream(is);
        XMLStreamReader subReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        XMLExtendedStreamReaderImpl reader = new XMLExtendedStreamReaderImpl(this, subReader);
        this.parse(reader, holder);
        subReader.close();
        for (ParserContext parserContext : holder.getParserContexts().values()) {
            parserContext.fireParsingComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        try {
            reader.require(7, null, null);
            reader.nextTag();
            reader.require(1, null, null);
            this.parseElement(reader, holder);
            while (reader.next() != 8) {
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void parseElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        QName name = reader.getName();
        ConfigurationParser parser = (ConfigurationParser)this.parserMappings.get(name);
        if (parser == null) {
            throw log.unsupportedConfiguration(name.getLocalPart(), name.getNamespaceURI());
        }
        parser.readElement(reader, holder);
    }
}

