/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.metadata.Metadata;

public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(CacheEntry<K, V> entry) {
        return new EntryBackedReadOnlyView(entry);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(K key, V value, Metadata metadata) {
        return new StaticReadOnlyView(key, value, metadata);
    }

    public static <K, V> EntryView.WriteEntryView<V> writeOnly(CacheEntry<K, V> entry) {
        return new EntryBackedWriteOnlyView(entry);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> readWrite(CacheEntry<K, V> entry) {
        return new EntryBackedReadWriteView(entry);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> readWrite(CacheEntry<K, V> entry, V prevValue, Metadata prevMetadata) {
        return new EntryAndPreviousReadWriteView(entry, prevValue, prevMetadata);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> immutableReadWrite(EntryView.ReadWriteEntryView<K, V> view) {
        Metadata metadata;
        Object key = view.key();
        Optional maybeV = view.find();
        if (view instanceof EntryBackedReadWriteView) {
            metadata = ((EntryBackedReadWriteView)view).entry.getMetadata();
        } else if (view instanceof EntryAndPreviousReadWriteView) {
            metadata = ((EntryAndPreviousReadWriteView)view).prevMetadata;
        } else {
            throw new IllegalStateException("Unknow read-write view: " + view);
        }
        return new ImmutableReadWriteView(key, maybeV, metadata);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> immutableReadWrite(K key, V value, Metadata metadata) {
        return new ImmutableReadWriteView<K, V>(key, Optional.ofNullable(value), metadata);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> noValue(K key) {
        return new NoValueReadOnlyView(key);
    }

    private static <K, V> MetaParams updateMetaParams(CacheEntry<K, V> entry, MetaParam.Writable[] metas) {
        if (metas.length != 0) {
            MetaParams metaParams = MetaParams.empty();
            metaParams.addMany(metas);
            entry.setMetadata(MetaParamsInternalMetadata.from(metaParams));
            return metaParams;
        }
        MetaParams empty = MetaParams.empty();
        entry.setMetadata(MetaParamsInternalMetadata.from(empty));
        return empty;
    }

    private static <K, V> MetaParams extractMetaParams(CacheEntry<K, V> entry) {
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MetaParamsInternalMetadata) {
            MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
            return metaParamsMetadata.params;
        }
        return MetaParams.empty();
    }

    public static final class ImmutableReadWriteViewExternalizer
    extends AbstractExternalizer<ImmutableReadWriteView> {
        @Override
        public Integer getId() {
            return 157;
        }

        @Override
        public Set<Class<? extends ImmutableReadWriteView>> getTypeClasses() {
            return Util.asSet(ImmutableReadWriteView.class);
        }

        @Override
        public void writeObject(ObjectOutput output, ImmutableReadWriteView obj) throws IOException {
            output.writeObject(obj.key);
            output.writeObject(obj.maybeV);
            output.writeObject(obj.metadata);
        }

        @Override
        public ImmutableReadWriteView readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Optional value = (Optional)input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            return new ImmutableReadWriteView(key, value, metadata);
        }
    }

    private static final class ImmutableReadWriteView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final K key;
        final Optional<V> maybeV;
        final Metadata metadata;

        public ImmutableReadWriteView(K key, Optional<V> maybeV, Metadata metadata) {
            this.key = key;
            this.maybeV = maybeV;
            this.metadata = metadata;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            return this.maybeV.get();
        }

        @Override
        public Optional<V> find() {
            return this.maybeV;
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            if (this.metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)this.metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }

        @Override
        public Void remove() {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }
    }

    private static final class NoValueReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;

        public NoValueReadOnlyView(K key) {
            this.key = key;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            throw new NoSuchElementException("No value");
        }

        @Override
        public Optional<V> find() {
            return Optional.empty();
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            return Optional.empty();
        }
    }

    private static final class EntryAndPreviousReadWriteView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final CacheEntry<K, V> entry;
        final V prevValue;
        final Metadata prevMetadata;

        private EntryAndPreviousReadWriteView(CacheEntry<K, V> entry, V prevValue, Metadata prevMetadata) {
            this.entry = entry;
            this.prevValue = prevValue;
            this.prevMetadata = prevMetadata;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.prevValue == null ? Optional.empty() : Optional.ofNullable(this.prevValue);
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setOnly(value, metas);
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        @Override
        public Void remove() {
            if (!this.entry.isNull()) {
                this.entry.setRemoved(true);
                this.entry.setChanged(true);
            }
            return null;
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.prevMetadata;
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            return this.prevValue;
        }
    }

    private static final class EntryBackedReadWriteView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final CacheEntry<K, V> entry;

        private EntryBackedReadWriteView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.entry.getValue());
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setOnly(value, metas);
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        @Override
        public Void remove() {
            if (!this.entry.isNull()) {
                this.entry.setRemoved(true);
                this.entry.setChanged(true);
            }
            return null;
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.entry.getValue();
        }
    }

    private static final class EntryBackedWriteOnlyView<K, V>
    implements EntryView.WriteEntryView<V> {
        final CacheEntry<K, V> entry;

        private EntryBackedWriteOnlyView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
            return null;
        }

        @Override
        public Void remove() {
            this.entry.setRemoved(true);
            this.entry.setChanged(true);
            return null;
        }
    }

    private static final class StaticReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;
        final V value;
        final Metadata metadata;

        private StaticReadOnlyView(K key, V value, Metadata metadata) {
            this.key = key;
            this.value = value;
            this.metadata = metadata;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.value == null) {
                throw new NoSuchElementException("No value");
            }
            return this.value;
        }

        @Override
        public Optional<V> find() {
            return this.value == null ? Optional.empty() : Optional.ofNullable(this.value);
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            if (this.metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)this.metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }
    }

    private static final class EntryBackedReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final CacheEntry<K, V> entry;

        private EntryBackedReadOnlyView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.entry.getValue());
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.entry.getValue();
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }
    }
}

