/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.Version;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollectionAdapter;
import org.infinispan.commons.util.CloseableIteratorSetAdapter;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.concurrent.NoOpFuture;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.iteration.EntryIterable;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.stream.impl.local.LocalEntryCacheStream;
import org.infinispan.stream.impl.local.LocalKeyCacheStream;
import org.infinispan.stream.impl.local.LocalValueCacheStream;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Cache", description="Component that represents a simplified cache instance.")
public class SimpleCacheImpl<K, V>
implements AdvancedCache<K, V> {
    private static final Log log = LogFactory.getLog(SimpleCacheImpl.class);
    private static final String NULL_KEYS_NOT_SUPPORTED = "Null keys are not supported!";
    private static final String NULL_VALUES_NOT_SUPPORTED = "Null values are not supported!";
    private static final Class<? extends Annotation>[] FIRED_EVENTS = new Class[]{CacheEntryCreated.class, CacheEntryRemoved.class, CacheEntryVisited.class, CacheEntryModified.class, CacheEntriesEvicted.class, CacheEntryInvalidated.class, CacheEntryExpired.class};
    private final String name;
    private ComponentRegistry componentRegistry;
    private Configuration configuration;
    private EmbeddedCacheManager cacheManager;
    private DataContainer<K, V> dataContainer;
    private CacheNotifier<K, V> cacheNotifier;
    private TimeService timeService;
    private InternalEntryFactory entryFactory;
    private Metadata defaultMetadata;
    private Equivalence<Object> keyEquivalence;
    private Equivalence<Object> valueEquivalence;
    private boolean hasListeners = false;

    public SimpleCacheImpl(String cacheName) {
        this.name = cacheName;
    }

    @Inject
    public void injectDependencies(ComponentRegistry componentRegistry, Configuration configuration, EmbeddedCacheManager cacheManager, DataContainer dataContainer, CacheNotifier cacheNotifier, TimeService timeService, InternalEntryFactory entryFactory) {
        this.componentRegistry = componentRegistry;
        this.configuration = configuration;
        this.cacheManager = cacheManager;
        this.dataContainer = dataContainer;
        this.cacheNotifier = cacheNotifier;
        this.timeService = timeService;
        this.entryFactory = entryFactory;
    }

    @Override
    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.configuration.expiration().lifespan()).maxIdle(this.configuration.expiration().maxIdle()).build();
        this.keyEquivalence = this.configuration.dataContainer().keyEquivalence();
        this.valueEquivalence = this.configuration.dataContainer().valueEquivalence();
        this.componentRegistry.start();
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.dataContainer = null;
        this.componentRegistry.stop();
    }

    @Override
    public void putForExternalRead(K key, V value) {
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, this.defaultMetadata, isCreatedRef);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = this.createMetadata(lifespan, unit);
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, metadata, isCreatedRef);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, metadata, isCreatedRef);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        ByRef.Boolean isCreatedRef = new ByRef.Boolean(false);
        this.putForExternalReadInternal(key, value, this.applyDefaultMetadata(metadata), isCreatedRef);
    }

    protected void putForExternalReadInternal(K key, V value, Metadata metadata, ByRef.Boolean isCreatedRef) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (this.isNull(oldEntry)) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryCreated(k, value, metadata, true, ImmutableContext.INSTANCE, null);
                }
                isCreatedRef.set(true);
                return factory.create(k, value, metadata);
            }
            return oldEntry;
        });
        if (hasListeners && isCreatedRef.get()) {
            this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, false, ImmutableContext.INSTANCE, null);
        }
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, Metadata metadata) {
        return new NoOpFuture<V>(this.getAndPutInternal(key, value, this.applyDefaultMetadata(metadata)));
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        Map<Object, Object> map = CollectionFactory.makeMap(keys.size(), this.keyEquivalence, this.valueEquivalence);
        for (Object k : keys) {
            Objects.requireNonNull(k, NULL_KEYS_NOT_SUPPORTED);
            InternalCacheEntry<K, V> entry = this.getDataContainer().get(k);
            if (entry == null) continue;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.hasListeners) {
                this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null);
                this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null);
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object k) {
        InternalCacheEntry<K, V> entry = this.getDataContainer().get(k);
        if (entry != null) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.hasListeners) {
                this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null);
                this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null);
            }
        }
        return entry;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        Map map = CollectionFactory.makeMap(keys.size(), this.keyEquivalence, AnyEquivalence.getInstance());
        for (Object key : keys) {
            Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
            InternalCacheEntry<K, V> entry = this.getDataContainer().get(key);
            if (entry == null) continue;
            Object value = entry.getValue();
            if (this.hasListeners) {
                this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null);
                this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null);
            }
            map.put(entry.getKey(), entry);
        }
        return map;
    }

    @Override
    public EntryIterable<K, V> filterEntries(KeyValueFilter<? super K, ? super V> filter) {
        if (filter != null) {
            this.componentRegistry.wireDependencies(filter);
        }
        return new FilteredEntryIterable(filter);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void removeGroup(String groupName) {
    }

    @Override
    public AvailabilityMode getAvailability() {
        return AvailabilityMode.AVAILABLE;
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evict(K key) {
        ByRef<Object> oldEntryRef = new ByRef<Object>(null);
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (!this.isNull(oldEntry)) {
                oldEntryRef.set(oldEntry);
            }
            return null;
        });
        InternalCacheEntry oldEntry2 = oldEntryRef.get();
        if (this.hasListeners && oldEntry2 != null) {
            this.cacheNotifier.notifyCacheEntriesEvicted(Collections.singleton(oldEntry2), ImmutableContext.INSTANCE, null);
        }
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.configuration;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    protected boolean checkExpiration(InternalCacheEntry<K, V> entry, long now) {
        if (entry.isExpired(now)) {
            return null == this.dataContainer.compute(entry.getKey(), (K key, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
                if (entry.isExpired(now)) {
                    this.cacheNotifier.notifyCacheEntryExpired(key, oldEntry.getValue(), oldEntry.getMetadata(), ImmutableContext.INSTANCE);
                    return null;
                }
                return oldEntry;
            });
        }
        return false;
    }

    @Override
    public int size() {
        long now = Long.MIN_VALUE;
        int size = 0;
        DataContainer<K, V> dataContainer = this.getDataContainer();
        for (InternalCacheEntry<K, V> entry : dataContainer) {
            if (entry.canExpire()) {
                if (now == Long.MIN_VALUE) {
                    now = this.timeService.wallClockTime();
                }
                if (this.checkExpiration(entry, now) || ++size >= 0) continue;
                return Integer.MAX_VALUE;
            }
            if (++size >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        long now = Long.MIN_VALUE;
        DataContainer<K, V> dataContainer = this.getDataContainer();
        for (InternalCacheEntry<K, V> entry : dataContainer) {
            if (entry.canExpire()) {
                if (now == Long.MIN_VALUE) {
                    now = this.timeService.wallClockTime();
                }
                if (this.checkExpiration(entry, now)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        for (V v : this.getDataContainer().values()) {
            if (!this.valueEquivalence.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        InternalCacheEntry<K, V> entry = this.getDataContainer().get(key);
        if (entry == null) {
            return null;
        }
        if (this.hasListeners) {
            this.cacheNotifier.notifyCacheEntryVisited(entry.getKey(), entry.getValue(), true, ImmutableContext.INSTANCE, null);
            this.cacheNotifier.notifyCacheEntryVisited(entry.getKey(), entry.getValue(), false, ImmutableContext.INSTANCE, null);
        }
        return entry.getValue();
    }

    @Override
    public CacheSet<K> keySet() {
        return new KeySet();
    }

    @Override
    public CacheCollection<V> values() {
        return new Values();
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return new CacheEntrySet();
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        this.checkExpiration(this.getDataContainer().get(key), this.timeService.wallClockTime());
    }

    @Override
    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public void clear() {
        DataContainer<K, V> dataContainer = this.getDataContainer();
        boolean hasListeners = this.hasListeners;
        ArrayList<InternalCacheEntry> copyEntries = null;
        if (hasListeners) {
            copyEntries = new ArrayList<InternalCacheEntry>(dataContainer.size());
            for (InternalCacheEntry internalCacheEntry : dataContainer.entrySet()) {
                copyEntries.add(internalCacheEntry);
                this.cacheNotifier.notifyCacheEntryRemoved(internalCacheEntry.getKey(), internalCacheEntry.getValue(), internalCacheEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
            }
        }
        dataContainer.clear();
        if (hasListeners) {
            for (InternalCacheEntry internalCacheEntry : copyEntries) {
                this.cacheNotifier.notifyCacheEntryRemoved(internalCacheEntry.getKey(), internalCacheEntry.getValue(), internalCacheEntry.getMetadata(), false, ImmutableContext.INSTANCE, null);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @Override
    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getVersion() {
        return Version.getVersion();
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.configuration);
    }

    @Override
    public V put(K key, V value) {
        return this.getAndPutInternal(key, value, this.defaultMetadata);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = this.createMetadata(lifespan, unit);
        return this.getAndPutInternal(key, value, metadata);
    }

    protected V getAndPutInternal(K key, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ValueAndMetadata oldRef = new ValueAndMetadata();
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (this.isNull(oldEntry)) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, true, ImmutableContext.INSTANCE, null);
                }
            } else {
                oldRef.set(oldEntry.getValue(), oldEntry.getMetadata());
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldEntry.getValue(), oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
            }
            if (oldEntry == null) {
                return factory.create(k, value, metadata);
            }
            return factory.update(oldEntry, value, metadata);
        });
        Object oldValue = oldRef.getValue();
        if (hasListeners) {
            if (oldValue == null) {
                this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, false, ImmutableContext.INSTANCE, null);
            } else {
                this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldValue, oldRef.getMetadata(), false, ImmutableContext.INSTANCE, null);
            }
        }
        return oldValue;
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = this.createMetadata(lifespan, unit);
        return this.putIfAbsentInternal(key, value, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.putIfAbsentInternal(key, value, this.applyDefaultMetadata(metadata));
    }

    protected V putIfAbsentInternal(K key, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ByRef<Object> oldValueRef = new ByRef<Object>(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (this.isNull(oldEntry)) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, true, ImmutableContext.INSTANCE, null);
                }
                return factory.create(k, value, metadata);
            }
            oldValueRef.set(oldEntry.getValue());
            return oldEntry;
        });
        V oldValue = oldValueRef.get();
        if (hasListeners && oldValue == null) {
            this.cacheNotifier.notifyCacheEntryCreated(key, value, metadata, false, ImmutableContext.INSTANCE, null);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAllInternal(map, this.createMetadata(lifespan, unit));
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        Metadata metadata = this.createMetadata(lifespan, unit);
        return this.getAndReplaceInternal(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replaceInternal(key, oldValue, value, this.createMetadata(lifespan, unit));
    }

    protected V getAndReplaceInternal(K key, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ValueAndMetadata oldRef = new ValueAndMetadata();
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (!this.isNull(oldEntry)) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldEntry.getValue(), oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
                oldRef.set(oldEntry.getValue(), oldEntry.getMetadata());
                return factory.update(oldEntry, value, metadata);
            }
            return oldEntry;
        });
        Object oldValue = oldRef.getValue();
        if (hasListeners && oldValue != null) {
            this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldValue, oldRef.getMetadata(), false, ImmutableContext.INSTANCE, null);
        }
        return oldValue;
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.getAndPutInternal(key, value, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.putIfAbsentInternal(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.putAllInternal(map, this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.getAndReplaceInternal(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = this.createMetadata(lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.replaceInternal(key, oldValue, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.replaceInternal(key, oldValue, value, this.applyDefaultMetadata(metadata));
    }

    protected boolean replaceInternal(K key, V oldValue, V value, Metadata metadata) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        Objects.requireNonNull(oldValue, NULL_VALUES_NOT_SUPPORTED);
        ValueAndMetadata oldRef = new ValueAndMetadata();
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V prevValue = this.getValue(oldEntry);
            if (this.valueEquivalence.equals(prevValue, oldValue)) {
                oldRef.set(prevValue, oldEntry.getMetadata());
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, prevValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
                return factory.update(oldEntry, value, metadata);
            }
            return oldEntry;
        });
        if (oldRef.getValue() != null) {
            if (hasListeners) {
                this.cacheNotifier.notifyCacheEntryModified(key, value, metadata, oldRef.getValue(), oldRef.getMetadata(), false, ImmutableContext.INSTANCE, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        ByRef<Object> oldEntryRef = new ByRef<Object>(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            if (!this.isNull(oldEntry)) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryRemoved(oldEntry.getKey(), oldEntry.getValue(), oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
                oldEntryRef.set(oldEntry);
            }
            return null;
        });
        InternalCacheEntry oldEntry2 = oldEntryRef.get();
        if (oldEntry2 != null) {
            if (hasListeners) {
                this.cacheNotifier.notifyCacheEntryRemoved(oldEntry2.getKey(), oldEntry2.getValue(), oldEntry2.getMetadata(), false, ImmutableContext.INSTANCE, null);
            }
            return oldEntry2.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAllInternal(map, this.defaultMetadata);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value) {
        return new NoOpFuture<V>(this.put(key, value));
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return new NoOpFuture<V>(this.put(key, value, lifespan, unit));
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new NoOpFuture<V>(this.put(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        this.putAll(data);
        return new NoOpFuture<Void>((Void)null);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        this.putAll(data, lifespan, unit);
        return new NoOpFuture<Void>((Void)null);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.putAll(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        return new NoOpFuture<Void>((Void)null);
    }

    @Override
    public NotifyingFuture<Void> clearAsync() {
        this.clear();
        return new NoOpFuture<Void>((Void)null);
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return new NoOpFuture<V>(this.putIfAbsent(key, value));
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return new NoOpFuture<V>(this.putIfAbsent(key, value, lifespan, unit));
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new NoOpFuture<V>(this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public NotifyingFuture<V> removeAsync(Object key) {
        return new NoOpFuture<V>(this.remove(key));
    }

    @Override
    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return new NoOpFuture<Boolean>(this.remove(key, value));
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value) {
        return new NoOpFuture<V>(this.replace(key, value));
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return new NoOpFuture<V>(this.replace(key, value, lifespan, unit));
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new NoOpFuture<V>(this.replace(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return new NoOpFuture<Boolean>(this.replace(key, oldValue, newValue));
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return new NoOpFuture<Boolean>(this.replace(key, oldValue, newValue, lifespan, unit));
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return new NoOpFuture<Boolean>(this.replace(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit));
    }

    @Override
    public NotifyingFuture<V> getAsync(K key) {
        return new NoOpFuture<V>(this.get(key));
    }

    @Override
    public boolean startBatch() {
        throw log.invocationBatchingNotEnabled();
    }

    @Override
    public void endBatch(boolean successful) {
        throw log.invocationBatchingNotEnabled();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsentInternal(key, value, this.defaultMetadata);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        Objects.requireNonNull(value, NULL_VALUES_NOT_SUPPORTED);
        ByRef<Object> oldEntryRef = new ByRef<Object>(null);
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            if (this.valueEquivalence.equals(oldValue, value)) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryRemoved(oldEntry.getKey(), oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
                oldEntryRef.set(oldEntry);
                return null;
            }
            return oldEntry;
        });
        InternalCacheEntry oldEntry2 = oldEntryRef.get();
        if (oldEntry2 != null) {
            if (hasListeners) {
                this.cacheNotifier.notifyCacheEntryRemoved(oldEntry2.getKey(), oldEntry2.getValue(), oldEntry2.getMetadata(), false, ImmutableContext.INSTANCE, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replaceInternal(key, oldValue, newValue, this.defaultMetadata);
    }

    @Override
    public V replace(K key, V value) {
        return this.getAndReplaceInternal(key, value, this.defaultMetadata);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.cacheNotifier.addListener(listener, filter);
        if (!this.hasListeners && this.canFire(listener)) {
            this.hasListeners = true;
        }
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.cacheNotifier.addListener(listener, filter, converter);
        if (!this.hasListeners && this.canFire(listener)) {
            this.hasListeners = true;
        }
    }

    @Override
    public void addListener(Object listener) {
        this.cacheNotifier.addListener(listener);
        if (!this.hasListeners && this.canFire(listener)) {
            this.hasListeners = true;
        }
    }

    @Override
    public void removeListener(Object listener) {
        this.cacheNotifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.cacheNotifier.getListeners();
    }

    private boolean canFire(Object listener) {
        for (Method m : listener.getClass().getMethods()) {
            for (Class<? extends Annotation> annotation : FIRED_EVENTS) {
                if (!m.isAnnotationPresent(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private Metadata applyDefaultMetadata(Metadata metadata) {
        Metadata.Builder builder = metadata.builder();
        return builder != null ? builder.merge(this.defaultMetadata).build() : metadata;
    }

    private Metadata createMetadata(long lifespan, TimeUnit unit) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.configuration.expiration().maxIdle()).build();
    }

    private Metadata createMetadata(long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return this;
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        throw log.interceptorStackNotSupported();
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        throw log.interceptorStackNotSupported();
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        throw log.interceptorStackNotSupported();
    }

    @Override
    public void removeInterceptor(int position) {
        throw log.interceptorStackNotSupported();
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        throw log.interceptorStackNotSupported();
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.getComponentRegistry().getComponent(EvictionManager.class);
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        return this.getComponentRegistry().getComponent(ExpirationManager.class);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.getComponentRegistry().getComponent(DistributionManager.class);
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.getComponentRegistry().getComponent(AuthorizationManager.class);
    }

    @Override
    public boolean lock(K ... keys) {
        throw log.lockOperationsNotSupported();
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        throw log.lockOperationsNotSupported();
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RpcManager getRpcManager() {
        return null;
    }

    @Override
    public BatchContainer getBatchContainer() {
        return null;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return null;
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        DataContainer<K, V> dataContainer = this.dataContainer;
        if (dataContainer == null) {
            ComponentStatus status = this.getStatus();
            switch (status) {
                case STOPPING: {
                    throw log.cacheIsStopping(this.name);
                }
                case TERMINATED: 
                case FAILED: {
                    throw log.cacheIsTerminated(this.name);
                }
            }
            throw new IllegalStateException("Status: " + (Object)((Object)status));
        }
        return dataContainer;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return null;
    }

    @Override
    public LockManager getLockManager() {
        return null;
    }

    @Override
    public Stats getStats() {
        return null;
    }

    @Override
    public XAResource getXAResource() {
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return this;
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.getAndPutInternal(key, value, this.applyDefaultMetadata(metadata));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.putAllInternal(map, this.applyDefaultMetadata(metadata));
    }

    protected void putAllInternal(Map<? extends K, ? extends V> map, Metadata metadata) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Objects.requireNonNull(entry.getKey(), NULL_KEYS_NOT_SUPPORTED);
            Objects.requireNonNull(entry.getValue(), NULL_VALUES_NOT_SUPPORTED);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.getAndPutInternal(entry.getKey(), entry.getValue(), metadata);
        }
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.getAndReplaceInternal(key, value, this.applyDefaultMetadata(metadata));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        ByRef<Object> newValueRef = new ByRef<Object>(null);
        return this.computeIfAbsentInternal(key, mappingFunction, newValueRef);
    }

    protected V computeIfAbsentInternal(K key, Function<? super K, ? extends V> mappingFunction, ByRef<V> newValueRef) {
        boolean hasListeners = this.hasListeners;
        InternalCacheEntry<Object, V> returnEntry = this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            if (oldValue == null) {
                Object newValue = mappingFunction.apply((K)k);
                if (newValue == null) {
                    return null;
                }
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryCreated(k, newValue, this.defaultMetadata, true, ImmutableContext.INSTANCE, null);
                }
                newValueRef.set(newValue);
                return factory.create(k, newValue, this.defaultMetadata);
            }
            return oldEntry;
        });
        V newValue = newValueRef.get();
        if (hasListeners && newValue != null) {
            this.cacheNotifier.notifyCacheEntryCreated(key, newValueRef.get(), this.defaultMetadata, false, ImmutableContext.INSTANCE, null);
        }
        return returnEntry.getValue();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(key, NULL_KEYS_NOT_SUPPORTED);
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeIfPresentInternal(key, remappingFunction, ref);
    }

    protected V computeIfPresentInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref) {
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            if (oldValue != null) {
                Object newValue = remappingFunction.apply((K)k, (V)oldValue);
                if (newValue == null) {
                    if (hasListeners) {
                        this.cacheNotifier.notifyCacheEntryRemoved(k, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                    }
                    ref.set(k, null, oldValue, oldEntry.getMetadata());
                    return null;
                }
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryModified(k, newValue, this.defaultMetadata, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
                ref.set(k, newValue, oldValue, oldEntry.getMetadata());
                return factory.update(oldEntry, newValue, this.defaultMetadata);
            }
            return null;
        });
        V newValue = ref.getNewValue();
        if (hasListeners) {
            if (newValue != null) {
                this.cacheNotifier.notifyCacheEntryModified(ref.getKey(), newValue, this.defaultMetadata, ref.getOldValue(), ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null);
            } else {
                this.cacheNotifier.notifyCacheEntryRemoved(ref.getKey(), ref.getOldValue(), ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null);
            }
        }
        return newValue;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.computeInternal(key, remappingFunction, ref);
    }

    protected V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref) {
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            Object newValue = remappingFunction.apply((K)k, (V)oldValue);
            return this.getUpdatedEntry(k, oldEntry, factory, oldValue, newValue, ref, hasListeners);
        });
        return this.notifyAndReturn(ref, hasListeners);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        CacheEntryChange ref = new CacheEntryChange();
        return this.mergeInternal(key, value, remappingFunction, ref);
    }

    protected V mergeInternal(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, CacheEntryChange<K, V> ref) {
        boolean hasListeners = this.hasListeners;
        this.getDataContainer().compute(key, (K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory) -> {
            V oldValue = this.getValue(oldEntry);
            Object newValue = remappingFunction.apply((V)oldValue, (V)value);
            return this.getUpdatedEntry(k, oldEntry, factory, oldValue, newValue, ref, hasListeners);
        });
        return this.notifyAndReturn(ref, hasListeners);
    }

    private V notifyAndReturn(CacheEntryChange<K, V> ref, boolean hasListeners) {
        K key = ref.getKey();
        V newValue = ref.getNewValue();
        if (key != null) {
            V oldValue = ref.getOldValue();
            if (hasListeners) {
                if (newValue == null) {
                    this.cacheNotifier.notifyCacheEntryRemoved(key, oldValue, ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null);
                } else if (oldValue == null) {
                    this.cacheNotifier.notifyCacheEntryCreated(key, newValue, this.defaultMetadata, false, ImmutableContext.INSTANCE, null);
                } else {
                    this.cacheNotifier.notifyCacheEntryModified(key, newValue, this.defaultMetadata, oldValue, ref.getOldMetadata(), false, ImmutableContext.INSTANCE, null);
                }
            }
        }
        return newValue;
    }

    private InternalCacheEntry<K, V> getUpdatedEntry(K k, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory, V oldValue, V newValue, CacheEntryChange<K, V> ref, boolean hasListeners) {
        if (newValue == null) {
            if (oldValue != null) {
                if (hasListeners) {
                    this.cacheNotifier.notifyCacheEntryRemoved(k, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
                }
                ref.set(k, null, oldValue, oldEntry.getMetadata());
            }
            return null;
        }
        if (oldValue == null) {
            if (hasListeners) {
                this.cacheNotifier.notifyCacheEntryCreated(k, newValue, this.defaultMetadata, true, ImmutableContext.INSTANCE, null);
            }
            ref.set(k, newValue, null, null);
            return factory.create(k, newValue, this.defaultMetadata);
        }
        if (this.valueEquivalence.equals(oldValue, newValue)) {
            return oldEntry;
        }
        if (hasListeners) {
            this.cacheNotifier.notifyCacheEntryModified(k, newValue, this.defaultMetadata, oldValue, oldEntry.getMetadata(), true, ImmutableContext.INSTANCE, null);
        }
        ref.set(k, newValue, oldValue, oldEntry.getMetadata());
        return factory.update(oldEntry, newValue, this.defaultMetadata);
    }

    private boolean isNull(InternalCacheEntry<K, V> entry) {
        if (entry == null) {
            return true;
        }
        if (entry.canExpire() && entry.isExpired(this.timeService.wallClockTime())) {
            this.cacheNotifier.notifyCacheEntryExpired(entry.getKey(), entry.getValue(), entry.getMetadata(), ImmutableContext.INSTANCE);
            return true;
        }
        return false;
    }

    private V getValue(InternalCacheEntry<K, V> entry) {
        return this.isNull(entry) ? null : (V)entry.getValue();
    }

    protected Supplier<Stream<CacheEntry<K, V>>> getStreamSupplier(boolean parallel) {
        CloseableSpliterator spliterator = Closeables.spliterator(Closeables.iterator(this.dataContainer.iterator()), this.dataContainer.size(), 4353);
        return () -> StreamSupport.stream(spliterator, parallel);
    }

    protected class ConvertingIterator<C>
    implements CloseableIterator<CacheEntry<K, C>> {
        private final Iterator<CacheEntry<K, V>> iterator;
        private final Converter<? super K, ? super V, ? extends C> converter;

        private ConvertingIterator(Iterator<CacheEntry<K, V>> iterator, Converter<? super K, ? super V, ? extends C> converter) {
            this.iterator = iterator;
            this.converter = converter;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CacheEntry<K, C> next() {
            CacheEntry entry = this.iterator.next();
            return SimpleCacheImpl.this.entryFactory.create(entry.getKey(), this.converter.convert(entry.getKey(), entry.getValue(), entry.getMetadata()), entry.getMetadata());
        }
    }

    protected class ConvertedIterable<C>
    implements CloseableIterable<CacheEntry<K, C>> {
        private final Iterator<CacheEntry<K, V>> iterator;
        private final Converter<? super K, ? super V, ? extends C> converter;

        public ConvertedIterable(Iterator<CacheEntry<K, V>> iterator, Converter<? super K, ? super V, ? extends C> converter) {
            this.iterator = iterator;
            this.converter = converter;
        }

        @Override
        public void close() {
        }

        @Override
        public CloseableIterator<CacheEntry<K, C>> iterator() {
            return new ConvertingIterator(this.iterator, this.converter);
        }
    }

    protected class FilteringIterator
    implements CloseableIterator<CacheEntry<K, V>> {
        private final KeyValueFilter filter;
        private Iterator<InternalCacheEntry<K, V>> iterator;
        private InternalCacheEntry<K, V> last;

        private FilteringIterator(KeyValueFilter filter) {
            this.iterator = SimpleCacheImpl.this.getDataContainer().iterator();
            this.last = null;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (this.last == null) {
                while (this.iterator.hasNext()) {
                    this.last = this.iterator.next();
                    if (this.last.canExpire() && SimpleCacheImpl.this.checkExpiration(this.last, SimpleCacheImpl.this.timeService.wallClockTime()) || this.filter != null && !this.filter.accept(this.last.getKey(), this.last.getValue(), this.last.getMetadata())) continue;
                    return true;
                }
                this.last = null;
                return false;
            }
            return true;
        }

        @Override
        public CacheEntry<K, V> next() {
            if (this.last == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            InternalCacheEntry tmp = this.last;
            this.last = null;
            return tmp;
        }

        @Override
        public void close() {
        }
    }

    protected class FilteredEntryIterable
    implements EntryIterable<K, V> {
        private final KeyValueFilter filter;

        public FilteredEntryIterable(KeyValueFilter<? super K, ? super V> filter) {
            this.filter = filter;
        }

        @Override
        public void close() {
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new FilteringIterator(this.filter);
        }

        @Override
        public <C> CloseableIterable<CacheEntry<K, C>> converter(Converter<? super K, ? super V, C> converter) {
            Objects.requireNonNull(converter);
            if (converter != this.filter) {
                SimpleCacheImpl.this.componentRegistry.wireDependencies(converter);
            }
            return new ConvertedIterable<C>(this.iterator(), converter);
        }
    }

    protected class KeySet
    extends CloseableIteratorSetAdapter<K>
    implements CacheSet<K> {
        public KeySet() {
            super(SimpleCacheImpl.this.getDataContainer().keySet());
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Set retained = CollectionFactory.makeSet(c.size(), SimpleCacheImpl.this.keyEquivalence);
            retained.addAll(c);
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (retained.contains(entry.getKey())) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey()) != null;
            }
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            return SimpleCacheImpl.this.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            for (Object key : c) {
                changed |= SimpleCacheImpl.this.remove(key) != null;
            }
            return changed;
        }

        @Override
        public void clear() {
            SimpleCacheImpl.this.clear();
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new CloseableIterator<K>(){
                private final FilteringIterator iterator;
                {
                    this.iterator = new FilteringIterator((key, value, metadata) -> true);
                }

                @Override
                public void close() {
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public K next() {
                    return this.iterator.next().getKey();
                }
            };
        }

        @Override
        public int size() {
            return SimpleCacheImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleCacheImpl.this.isEmpty();
        }

        @Override
        public CacheStream<K> stream() {
            Supplier supplier = SimpleCacheImpl.this.getStreamSupplier(false);
            return new LocalKeyCacheStream(SimpleCacheImpl.this, false, null, supplier, SimpleCacheImpl.this.getComponentRegistry());
        }

        @Override
        public CacheStream<K> parallelStream() {
            Supplier supplier = SimpleCacheImpl.this.getStreamSupplier(true);
            return new LocalKeyCacheStream(SimpleCacheImpl.this, true, null, supplier, SimpleCacheImpl.this.getComponentRegistry());
        }
    }

    protected class Values
    extends CloseableIteratorCollectionAdapter<V>
    implements CacheCollection<V> {
        public Values() {
            super(SimpleCacheImpl.this.getDataContainer().values());
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Set retained = CollectionFactory.makeSet(c.size(), SimpleCacheImpl.this.valueEquivalence);
            retained.addAll(c);
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (retained.contains(entry.getValue())) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            int removeSize = c.size();
            if (removeSize == 0) {
                return false;
            }
            if (removeSize == 1) {
                return this.remove(c.iterator().next());
            }
            Set removed = CollectionFactory.makeSet(removeSize, SimpleCacheImpl.this.valueEquivalence);
            removed.addAll(c);
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (!removed.contains(entry.getValue())) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (!SimpleCacheImpl.this.valueEquivalence.equals(entry.getValue(), o) || !SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SimpleCacheImpl.this.clear();
        }

        @Override
        public CloseableIterator<V> iterator() {
            return new CloseableIterator<V>(){
                FilteringIterator iterator;
                {
                    this.iterator = new FilteringIterator((key, value, metadata) -> true);
                }

                @Override
                public void close() {
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public V next() {
                    return this.iterator.next().getValue();
                }
            };
        }

        @Override
        public int size() {
            return SimpleCacheImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleCacheImpl.this.isEmpty();
        }

        @Override
        public CacheStream<V> stream() {
            return new LocalValueCacheStream(SimpleCacheImpl.this, false, null, SimpleCacheImpl.this.getStreamSupplier(false), SimpleCacheImpl.this.getComponentRegistry());
        }

        @Override
        public CacheStream<V> parallelStream() {
            return new LocalValueCacheStream(SimpleCacheImpl.this, true, null, SimpleCacheImpl.this.getStreamSupplier(true), SimpleCacheImpl.this.getComponentRegistry());
        }
    }

    protected class CacheEntrySet
    extends EntrySetBase<CacheEntry<K, V>>
    implements CacheSet<CacheEntry<K, V>> {
        protected CacheEntrySet() {
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new CloseableIterator<CacheEntry<K, V>>(){
                private final Iterator<? extends CacheEntry<K, V>> iterator;
                {
                    this.iterator = new FilteringIterator((key, value, metadata) -> true);
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public CacheEntry<K, V> next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return Closeables.spliterator(Closeables.iterator(SimpleCacheImpl.this.dataContainer.iterator()), SimpleCacheImpl.this.dataContainer.size(), 4353);
        }

        @Override
        public boolean add(CacheEntry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends CacheEntry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            Supplier supplier = SimpleCacheImpl.this.getStreamSupplier(false);
            return new LocalEntryCacheStream(SimpleCacheImpl.this, false, null, supplier, SimpleCacheImpl.this.getComponentRegistry());
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            Supplier supplier = SimpleCacheImpl.this.getStreamSupplier(false);
            return new LocalEntryCacheStream(SimpleCacheImpl.this, true, null, supplier, SimpleCacheImpl.this.getComponentRegistry());
        }
    }

    protected class EntrySet
    extends EntrySetBase<Map.Entry<K, V>>
    implements CacheSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public CloseableIterator<Map.Entry<K, V>> iterator() {
            return new CloseableIterator<Map.Entry<K, V>>(){
                private final Iterator<? extends Map.Entry<K, V>> iterator;
                {
                    this.iterator = new FilteringIterator((key, value, metadata) -> true);
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public CloseableSpliterator<Map.Entry<K, V>> spliterator() {
            return Closeables.spliterator(Closeables.iterator(SimpleCacheImpl.this.dataContainer.iterator()), SimpleCacheImpl.this.dataContainer.size(), 4353);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheStream<Map.Entry<K, V>> stream() {
            return new LocalEntryCacheStream(SimpleCacheImpl.this, false, null, SimpleCacheImpl.this.getStreamSupplier(false), SimpleCacheImpl.this.getComponentRegistry());
        }

        @Override
        public CacheStream<Map.Entry<K, V>> parallelStream() {
            return new LocalEntryCacheStream(SimpleCacheImpl.this, true, null, SimpleCacheImpl.this.getStreamSupplier(true), SimpleCacheImpl.this.getComponentRegistry());
        }
    }

    protected abstract class EntrySetBase<T extends Map.Entry<K, V>>
    implements CacheSet<T> {
        private final Set<? extends Map.Entry<K, V>> delegate;

        protected EntrySetBase() {
            this.delegate = SimpleCacheImpl.this.getDataContainer().entrySet();
        }

        @Override
        public int size() {
            return SimpleCacheImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SimpleCacheImpl.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean changed = false;
            for (InternalCacheEntry entry : SimpleCacheImpl.this.getDataContainer()) {
                if (c.contains(entry)) continue;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            for (Object o : c) {
                if (!(o instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)o;
                changed |= SimpleCacheImpl.this.remove(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        @Override
        public void clear() {
            SimpleCacheImpl.this.clear();
        }
    }

    protected static class CacheEntryChange<K, V> {
        private K key;
        private V newValue;
        private V oldValue;
        private Metadata oldMetadata;

        protected CacheEntryChange() {
        }

        public void set(K key, V newValue, V oldValue, Metadata oldMetadata) {
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
            this.oldMetadata = oldMetadata;
        }

        public K getKey() {
            return this.key;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public Metadata getOldMetadata() {
            return this.oldMetadata;
        }
    }

    protected static class ValueAndMetadata<V> {
        private V value;
        private Metadata metadata;

        protected ValueAndMetadata() {
        }

        public void set(V value, Metadata metadata) {
            this.value = value;
            this.metadata = metadata;
        }

        public V getValue() {
            return this.value;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }
    }
}

