/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry.impl;

import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.registry.impl.SecurityActions;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InternalCacheRegistryImpl
implements InternalCacheRegistry {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private EmbeddedCacheManager cacheManager;
    private final Set<String> internalCaches = new ConcurrentHashSet<String>();
    private final Set<String> privateCaches = new ConcurrentHashSet<String>();

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void registerInternalCache(String name, Configuration configuration) {
        this.registerInternalCache(name, configuration, EnumSet.noneOf(InternalCacheRegistry.Flag.class));
    }

    @Override
    public void registerInternalCache(String name, Configuration configuration, EnumSet<InternalCacheRegistry.Flag> flags) {
        if ((flags.contains((Object)InternalCacheRegistry.Flag.EXCLUSIVE) || !this.internalCaches.contains(name)) && this.cacheManager.getCacheConfiguration(name) != null) {
            throw log.existingConfigForInternalCache(name);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder().read(configuration);
        builder.jmxStatistics().disable();
        GlobalConfiguration globalConfiguration = this.cacheManager.getCacheManagerConfiguration();
        if (flags.contains((Object)InternalCacheRegistry.Flag.PERSISTENT) && globalConfiguration.statePersistence().enabled()) {
            ((SingleFileStoreConfigurationBuilder)builder.persistence().addSingleFileStore().location(globalConfiguration.statePersistence().location()).purgeOnStartup(false)).preload(true);
        }
        SecurityActions.defineConfiguration(this.cacheManager, name, builder.build());
        this.internalCaches.add(name);
        if (!flags.contains((Object)InternalCacheRegistry.Flag.USER)) {
            this.privateCaches.add(name);
        }
    }

    @Override
    public boolean isInternalCache(String name) {
        return this.internalCaches.contains(name);
    }

    @Override
    public Set<String> getInternalCacheNames() {
        return this.internalCaches;
    }

    @Override
    public void filterInternalCaches(Set<String> names) {
        names.removeAll(this.privateCaches);
    }
}

