/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<L1Configuration> {
    private static final Log log = LogFactory.getLog(L1ConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = L1Configuration.attributeDefinitionSet();

    L1ConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public L1ConfigurationBuilder invalidationThreshold(int invalidationThreshold) {
        this.attributes.attribute(L1Configuration.INVALIDATION_THRESHOLD).set(invalidationThreshold);
        return this;
    }

    public L1ConfigurationBuilder lifespan(long lifespan) {
        this.attributes.attribute(L1Configuration.LIFESPAN).set(lifespan);
        return this;
    }

    public L1ConfigurationBuilder lifespan(long lifespan, TimeUnit unit) {
        return this.lifespan(unit.toMillis(lifespan));
    }

    public L1ConfigurationBuilder cleanupTaskFrequency(long frequencyMillis) {
        this.attributes.attribute(L1Configuration.CLEANUP_TASK_FREQUENCY).set(frequencyMillis);
        return this;
    }

    public L1ConfigurationBuilder cleanupTaskFrequency(long frequencyMillis, TimeUnit unit) {
        return this.cleanupTaskFrequency(unit.toMillis(frequencyMillis));
    }

    public L1ConfigurationBuilder enable() {
        this.attributes.attribute(L1Configuration.ENABLED).set(true);
        return this;
    }

    public L1ConfigurationBuilder disable() {
        this.attributes.attribute(L1Configuration.ENABLED).set(false);
        return this;
    }

    public L1ConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(L1Configuration.ENABLED).set(enabled);
        return this;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(L1Configuration.ENABLED).get().booleanValue()) {
            if (!this.clustering().cacheMode().isDistributed()) {
                throw log.l1OnlyForDistributedCache(this.clustering().cacheMode().friendlyCacheModeString());
            }
            if (this.attributes.attribute(L1Configuration.LIFESPAN).get() < 1L) {
                throw log.l1InvalidLifespan();
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public L1Configuration create() {
        return new L1Configuration(this.attributes.protect());
    }

    public L1ConfigurationBuilder read(L1Configuration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "L1ConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

