/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.lang.invoke.MethodHandles;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStatePersistenceConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalStatePersistenceConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalStatePersistenceConfiguration> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final AttributeSet attributes = GlobalStatePersistenceConfiguration.attributeDefinitionSet();

    GlobalStatePersistenceConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public GlobalStatePersistenceConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public GlobalStatePersistenceConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public GlobalStatePersistenceConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalStatePersistenceConfiguration.ENABLED).set(enabled);
        return this;
    }

    public GlobalStatePersistenceConfigurationBuilder location(String location) {
        this.attributes.attribute(GlobalStatePersistenceConfiguration.LOCATION).set(location);
        return this;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(GlobalStatePersistenceConfiguration.ENABLED).get().booleanValue() && this.attributes.attribute(GlobalStatePersistenceConfiguration.LOCATION).isNull()) {
            throw log.missingGlobalPersistentStateLocation();
        }
    }

    @Override
    public GlobalStatePersistenceConfiguration create() {
        return new GlobalStatePersistenceConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(GlobalStatePersistenceConfiguration template) {
        return this;
    }
}

