/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractLocalCacheStream<R, K, V>
implements CacheStream<R> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final boolean parallel;
    protected final ConsistentHash hash;
    protected final Supplier<Stream<CacheEntry<K, V>>> supplier;
    protected final ComponentRegistry registry;
    protected final Collection<Runnable> onCloseRunnables = new ArrayList<Runnable>(4);
    protected Set<Integer> segmentsToFilter;
    protected Set<?> keysToFilter;
    protected Stream<R> stream;

    public AbstractLocalCacheStream(boolean parallel, ConsistentHash hash, Supplier<Stream<CacheEntry<K, V>>> supplier, ComponentRegistry registry) {
        this.parallel = parallel;
        this.hash = hash;
        this.supplier = supplier;
        this.registry = registry;
    }

    ConsistentHash getHash() {
        return this.hash;
    }

    Supplier<Stream<CacheEntry<K, V>>> getSupplier() {
        return this.supplier;
    }

    protected abstract Stream<R> getStream();

    private final Stream<R> getOrCreateStream() {
        if (this.stream == null) {
            this.stream = this.createStream();
        }
        return this.stream;
    }

    private final Stream<R> createStream() {
        Stream stream = this.getStream();
        for (Runnable runnable : this.onCloseRunnables) {
            stream = (Stream)stream.onClose(runnable);
        }
        return stream;
    }

    @Override
    public CacheStream<R> sequentialDistribution() {
        return this;
    }

    @Override
    public CacheStream<R> parallelDistribution() {
        return this;
    }

    @Override
    public CacheStream<R> filterKeySegments(Set<Integer> segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public CacheStream<R> filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public CacheStream<R> distributedBatchSize(int batchSize) {
        return this;
    }

    @Override
    public CacheStream<R> segmentCompletionListener(CacheStream.SegmentCompletionListener listener) {
        return this;
    }

    @Override
    public CacheStream<R> disableRehashAware() {
        return this;
    }

    @Override
    public Stream<R> filter(Predicate<? super R> predicate) {
        this.registry.wireDependencies(predicate);
        this.stream = this.getOrCreateStream().filter(predicate);
        return this;
    }

    @Override
    public <R1> Stream<R1> map(Function<? super R, ? extends R1> mapper) {
        this.registry.wireDependencies(mapper);
        this.stream = this.getOrCreateStream().map(mapper);
        return this;
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super R> mapper) {
        return this.getOrCreateStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super R> mapper) {
        return this.getOrCreateStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super R> mapper) {
        return this.getOrCreateStream().mapToDouble(mapper);
    }

    @Override
    public <R1> Stream<R1> flatMap(Function<? super R, ? extends Stream<? extends R1>> mapper) {
        this.stream = this.getOrCreateStream().flatMap(mapper);
        return this;
    }

    @Override
    public IntStream flatMapToInt(Function<? super R, ? extends IntStream> mapper) {
        return this.getOrCreateStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super R, ? extends LongStream> mapper) {
        return this.getOrCreateStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super R, ? extends DoubleStream> mapper) {
        return this.getOrCreateStream().flatMapToDouble(mapper);
    }

    @Override
    public Stream<R> distinct() {
        this.stream = this.getOrCreateStream().distinct();
        return this;
    }

    @Override
    public Stream<R> sorted() {
        this.stream = this.getOrCreateStream().sorted();
        return this;
    }

    @Override
    public Stream<R> sorted(Comparator<? super R> comparator) {
        this.stream = this.getOrCreateStream().sorted(comparator);
        return this;
    }

    @Override
    public Stream<R> peek(Consumer<? super R> action) {
        this.stream = this.getOrCreateStream().peek(action);
        return this;
    }

    @Override
    public Stream<R> limit(long maxSize) {
        this.stream = this.getOrCreateStream().limit(maxSize);
        return this;
    }

    @Override
    public Stream<R> skip(long n) {
        this.stream = this.getOrCreateStream().skip(n);
        return this;
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        this.getOrCreateStream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super R> action) {
        this.getOrCreateStream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.getOrCreateStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.getOrCreateStream().toArray(generator);
    }

    @Override
    public R reduce(R identity, BinaryOperator<R> accumulator) {
        return this.getOrCreateStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<R> reduce(BinaryOperator<R> accumulator) {
        return this.getOrCreateStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super R, U> accumulator, BinaryOperator<U> combiner) {
        return this.getOrCreateStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R1> R1 collect(Supplier<R1> supplier, BiConsumer<R1, ? super R> accumulator, BiConsumer<R1, R1> combiner) {
        return this.getOrCreateStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R1, A> R1 collect(Collector<? super R, A, R1> collector) {
        return this.getOrCreateStream().collect(collector);
    }

    @Override
    public Optional<R> min(Comparator<? super R> comparator) {
        return this.getOrCreateStream().min(comparator);
    }

    @Override
    public Optional<R> max(Comparator<? super R> comparator) {
        return this.getOrCreateStream().max(comparator);
    }

    @Override
    public long count() {
        return this.getOrCreateStream().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super R> predicate) {
        return this.getOrCreateStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super R> predicate) {
        return this.getOrCreateStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super R> predicate) {
        return this.getOrCreateStream().noneMatch(predicate);
    }

    @Override
    public Optional<R> findFirst() {
        return this.getOrCreateStream().findFirst();
    }

    @Override
    public Optional<R> findAny() {
        return this.getOrCreateStream().findAny();
    }

    @Override
    public CloseableIterator<R> iterator() {
        if (this.stream == null) {
            return this.removableIterator(Closeables.iterator(this.createStream()));
        }
        return Closeables.iterator(this.stream);
    }

    protected abstract CloseableIterator<R> removableIterator(CloseableIterator<R> var1);

    @Override
    public Spliterator<R> spliterator() {
        return this.getOrCreateStream().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.getOrCreateStream().isParallel();
    }

    @Override
    public Stream<R> sequential() {
        this.stream = (Stream)this.getOrCreateStream().sequential();
        return this;
    }

    @Override
    public Stream<R> parallel() {
        this.stream = (Stream)this.getOrCreateStream().parallel();
        return this;
    }

    @Override
    public Stream<R> unordered() {
        this.stream = (Stream)this.getOrCreateStream().unordered();
        return this;
    }

    @Override
    public Stream<R> onClose(Runnable closeHandler) {
        this.onCloseRunnables.add(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.getOrCreateStream().close();
    }

    @Override
    public CacheStream<R> timeout(long timeout, TimeUnit unit) {
        return this;
    }
}

