/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Set;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;

public class ExpirationInterceptor<K, V>
extends CommandInterceptor {
    protected ExpirationManager<K, V> expirationManager;

    @Inject
    public void inject(ExpirationManager<K, V> expirationManager) {
        this.expirationManager = expirationManager;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return super.visitClearCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Set<Object> keys = command.getAffectedKeys();
        keys.forEach(this.expirationManager::registerWriteIncoming);
        try {
            Object object = super.visitPutMapCommand(ctx, command);
            return object;
        }
        finally {
            keys.forEach(this.expirationManager::unregisterWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        Object key = command.getKey();
        this.expirationManager.registerWriteIncoming(key);
        try {
            Object object = this.handleDefault(ctx, command);
            return object;
        }
        finally {
            this.expirationManager.unregisterWrite(key);
        }
    }
}

