/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
public class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor {
    private final LongAdder hitTimes = new LongAdder();
    private final LongAdder missTimes = new LongAdder();
    private final LongAdder storeTimes = new LongAdder();
    private final LongAdder removeTimes = new LongAdder();
    private final LongAdder hits = new LongAdder();
    private final LongAdder misses = new LongAdder();
    private final LongAdder stores = new LongAdder();
    private final LongAdder evictions = new LongAdder();
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private final LongAdder removeHits = new LongAdder();
    private final LongAdder removeMisses = new LongAdder();
    private DataContainer dataContainer;
    private TimeService timeService;
    private static final Log log = LogFactory.getLog(CacheMgmtInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void setDependencies(DataContainer dataContainer, TimeService timeService) {
        this.dataContainer = dataContainer;
        this.timeService = timeService;
    }

    @Start
    public void start() {
        this.startNanoseconds.set(this.timeService.time());
        this.resetNanoseconds.set(this.startNanoseconds.get());
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.getStatisticsEnabled(command)) {
            this.evictions.increment();
        }
        return returnValue;
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal()) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            if (retval == null) {
                this.missTimes.add(intervalMilliseconds);
                this.misses.increment();
            } else {
                this.hitTimes.add(intervalMilliseconds);
                this.hits.increment();
            }
        }
        return retval;
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal()) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            int requests = command.getKeys().size();
            int hitCount = 0;
            for (Map.Entry entry : ((Map)retval).entrySet()) {
                if (entry.getValue() == null) continue;
                ++hitCount;
            }
            int missCount = requests - hitCount;
            if (hitCount > 0) {
                this.hits.add(hitCount);
                this.hitTimes.add(intervalMilliseconds * (long)hitCount / (long)requests);
            }
            if (missCount > 0) {
                this.misses.add(missCount);
                this.missTimes.add(intervalMilliseconds * (long)missCount / (long)requests);
            }
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal()) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            Map<Object, Object> data = command.getMap();
            if (data != null && !data.isEmpty()) {
                this.storeTimes.add(intervalMilliseconds);
                this.stores.add(data.size());
            }
        }
        return retval;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.updateStoreStatistics(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.updateStoreStatistics(ctx, command);
    }

    private Object updateStoreStatistics(InvocationContext ctx, WriteCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal() && command.isSuccessful()) {
            long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
            this.storeTimes.add(intervalMilliseconds);
            this.stores.increment();
        }
        return retval;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        long start = 0L;
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (statisticsEnabled) {
            start = this.timeService.time();
        }
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (statisticsEnabled && ctx.isOriginLocal()) {
            if (command.isConditional()) {
                if (command.isSuccessful()) {
                    this.increaseRemoveHits(start);
                } else {
                    this.increaseRemoveMisses();
                }
            } else if (retval == null) {
                this.increaseRemoveMisses();
            } else {
                this.increaseRemoveHits(start);
            }
        }
        return retval;
    }

    private void increaseRemoveHits(long start) {
        long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
        this.removeTimes.add(intervalMilliseconds);
        this.removeHits.increment();
    }

    private void increaseRemoveMisses() {
        this.removeMisses.increment();
    }

    @ManagedAttribute(description="Number of cache attribute hits", displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.hits.sum();
    }

    @ManagedAttribute(description="Number of cache attribute misses", displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.misses.sum();
    }

    @ManagedAttribute(description="Number of cache removal hits", displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.removeHits.sum();
    }

    @ManagedAttribute(description="Number of cache removals where keys were not found", displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.removeMisses.sum();
    }

    @ManagedAttribute(description="number of cache attribute put operations", displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.stores.sum();
    }

    @ManagedAttribute(description="Number of cache eviction operations", displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.evictions.sum();
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache", displayName="Hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        long hitsL = this.hits.sum();
        double total = hitsL + this.misses.sum();
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache", displayName="Read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        long sum = this.stores.sum();
        if (sum == 0L) {
            return 0.0;
        }
        return (double)(this.hits.sum() + this.misses.sum()) / (double)sum;
    }

    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache", displayName="Average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long total = this.hits.sum() + this.misses.sum();
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes.sum() + this.missTimes.sum()) / total;
    }

    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache", displayName="Average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        long sum = this.stores.sum();
        if (sum == 0L) {
            return 0L;
        }
        return this.storeTimes.sum() / sum;
    }

    @ManagedAttribute(description="Average number of milliseconds for a remove operation in the cache", displayName="Average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return this.removeTimes.sum() / removes;
    }

    @ManagedAttribute(description="Number of entries currently in memory including expired entries", displayName="Number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.dataContainer.sizeIncludingExpired();
    }

    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getTimeSinceStart() {
        return this.timeService.timeDuration(this.startNanoseconds.get(), TimeUnit.SECONDS);
    }

    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    @Deprecated
    public long getElapsedTime() {
        return this.getTimeSinceStart();
    }

    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset", displayName="Seconds since cache statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics (Statistics)")
    public void resetStatistics() {
        this.hits.reset();
        this.misses.reset();
        this.stores.reset();
        this.evictions.reset();
        this.hitTimes.reset();
        this.missTimes.reset();
        this.storeTimes.reset();
        this.removeHits.reset();
        this.removeTimes.reset();
        this.removeMisses.reset();
        this.resetNanoseconds.set(this.timeService.time());
    }

    private boolean getStatisticsEnabled(FlagAffectedCommand cmd) {
        return super.getStatisticsEnabled() && !cmd.hasFlag(Flag.SKIP_STATISTICS);
    }

    public void addEvictions(long numEvictions) {
        this.evictions.add(numEvictions);
    }
}

