/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.IntSummaryStatistics;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.exts.SecurityActions;

public class IntSummaryStatisticsExternalizer
extends AbstractExternalizer<IntSummaryStatistics> {
    static final Field countField = SecurityActions.getField(IntSummaryStatistics.class, "count");
    static final Field sumField = SecurityActions.getField(IntSummaryStatistics.class, "sum");
    static final Field minField = SecurityActions.getField(IntSummaryStatistics.class, "min");
    static final Field maxField = SecurityActions.getField(IntSummaryStatistics.class, "max");
    static final boolean canSerialize = countField != null && sumField != null && minField != null && maxField != null;

    @Override
    public Set<Class<? extends IntSummaryStatistics>> getTypeClasses() {
        return Util.asSet(IntSummaryStatistics.class);
    }

    private void verifySerialization() {
        if (!canSerialize) {
            throw new NotSerializableException("IntSummaryStatistics is not serializable, fields not available!");
        }
    }

    @Override
    public void writeObject(ObjectOutput output, IntSummaryStatistics object) throws IOException {
        this.verifySerialization();
        try {
            output.writeLong(countField.getLong(object));
            output.writeLong(sumField.getLong(object));
            output.writeInt(minField.getInt(object));
            output.writeInt(maxField.getInt(object));
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    @Override
    public IntSummaryStatistics readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        this.verifySerialization();
        IntSummaryStatistics summaryStatistics = new IntSummaryStatistics();
        try {
            countField.setLong(summaryStatistics, input.readLong());
            sumField.setLong(summaryStatistics, input.readLong());
            minField.setInt(summaryStatistics, input.readInt());
            maxField.setInt(summaryStatistics, input.readInt());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return summaryStatistics;
    }

    @Override
    public Integer getId() {
        return 21;
    }
}

