/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;

@BuiltBy(value=JdbcBinaryStoreConfigurationBuilder.class)
@ConfigurationFor(value=JdbcBinaryStore.class)
public class JdbcBinaryStoreConfiguration
extends AbstractJdbcStoreConfiguration {
    static final AttributeDefinition<Integer> CONCURRENCY_LEVEL = AttributeDefinition.builder("concurrencyLevel", 2048).immutable().build();
    static final AttributeDefinition<Long> LOCK_ACQUISITION_TIMEOUT = AttributeDefinition.builder("lockAcquisitionTimeout", 60000L).immutable().build();
    private final Attribute<Integer> concurrencyLevel;
    private final Attribute<Long> lockAcquisitionTimeout;
    private final TableManipulationConfiguration table;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(JdbcBinaryStoreConfiguration.class, AbstractJdbcStoreConfiguration.attributeDefinitionSet(), CONCURRENCY_LEVEL, LOCK_ACQUISITION_TIMEOUT);
    }

    public JdbcBinaryStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, ConnectionFactoryConfiguration connectionFactory, TableManipulationConfiguration table) {
        super(attributes, async, singletonStore, connectionFactory);
        this.table = table;
        this.concurrencyLevel = attributes.attribute(CONCURRENCY_LEVEL);
        this.lockAcquisitionTimeout = attributes.attribute(LOCK_ACQUISITION_TIMEOUT);
    }

    public TableManipulationConfiguration table() {
        return this.table;
    }

    public int lockConcurrencyLevel() {
        return this.concurrencyLevel.get();
    }

    public long lockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout.get();
    }

    @Override
    public String toString() {
        return "JdbcBinaryStoreConfiguration [table=" + this.table + ", attributes=" + this.attributes + ", connectionFactory=" + this.connectionFactory() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcBinaryStoreConfiguration other = (JdbcBinaryStoreConfiguration)obj;
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }
}

