/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockUtil;

public abstract class AbstractLockingInterceptor
extends CommandInterceptor {
    private boolean trace = this.getLog().isTraceEnabled();
    protected LockManager lockManager;
    protected DataContainer<Object, Object> dataContainer;
    protected ClusteringDependentLogic cdl;

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer<Object, Object> dataContainer, ClusteringDependentLogic cdl) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.cdl = cdl;
    }

    @Override
    public final Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    protected abstract Object visitDataReadCommand(InvocationContext var1, DataCommand var2) throws Throwable;

    protected abstract Object visitDataWriteCommand(InvocationContext var1, DataWriteCommand var2) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object visitNonTxDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            if (this.hasSkipLocking(command) || !this.shouldLockKey(command.getKey())) {
                Object object = this.invokeNextInterceptor(ctx, command);
                return object;
            }
            this.lockAndRecord(ctx, command.getKey(), this.getLockTimeoutMillis(command));
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        try {
            if (this.hasSkipLocking(command)) {
                Object object = this.invokeNextInterceptor(ctx, command);
                return object;
            }
            this.lockAllAndRecord(ctx, Arrays.asList(command.getKeys()), this.getLockTimeoutMillis(command));
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        if (command.isCausedByALocalWrite(this.cdl.getAddress())) {
            if (this.trace) {
                this.getLog().trace("Skipping invalidation as the write operation originated here.");
            }
            return null;
        }
        if (this.hasSkipLocking(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object[] keys = command.getKeys();
        try {
            if (keys != null && keys.length >= 1) {
                ArrayList<Object> keysToInvalidate = new ArrayList<Object>(keys.length);
                for (Object key : keys) {
                    try {
                        this.lockAndRecord(ctx, key, 0L);
                        keysToInvalidate.add(key);
                    }
                    catch (TimeoutException te) {
                        this.getLog().unableToLockToInvalidate(key, this.cdl.getAddress());
                    }
                }
                if (keysToInvalidate.isEmpty()) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                command.setKeys(keysToInvalidate.toArray());
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            command.setKeys(keys);
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command);
    }

    protected final Throwable cleanLocksAndRethrow(InvocationContext ctx, Throwable te) {
        this.lockManager.unlockAll(ctx);
        return te;
    }

    protected final long getLockTimeoutMillis(LocalFlagAffectedCommand command) {
        return command.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.cacheConfiguration.locking().lockAcquisitionTimeout();
    }

    protected final boolean shouldLockKey(Object key) {
        boolean shouldLock;
        boolean bl = shouldLock = LockUtil.getLockOwnership(key, this.cdl) == LockUtil.LockOwnership.PRIMARY;
        if (this.trace) {
            this.getLog().tracef("Are (%s) we the lock owners for key '%s'? %s", (Object)this.cdl.getAddress(), (Object)Util.toStr(key), (Object)shouldLock);
        }
        return shouldLock;
    }

    protected final void lockAndRecord(InvocationContext context, Object key, long timeout) throws InterruptedException {
        context.addLockedKey(key);
        this.lockManager.lock(key, context.getLockOwner(), timeout, TimeUnit.MILLISECONDS).lock();
    }

    protected final void lockAllAndRecord(InvocationContext context, Stream<?> keys, long timeout) throws InterruptedException {
        this.lockAllAndRecord(context, keys.collect(Collectors.toList()), timeout);
    }

    protected final void lockAllAndRecord(InvocationContext context, Collection<?> keys, long timeout) throws InterruptedException {
        keys.forEach(context::addLockedKey);
        this.lockManager.lockAll(keys, context.getLockOwner(), timeout, TimeUnit.MILLISECONDS).lock();
    }
}

