/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.iteration.EntryIterable;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.SecureCache;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.locks.LockManager;

public final class SecureCacheImpl<K, V>
implements SecureCache<K, V> {
    private final AuthorizationManager authzManager;
    private final AdvancedCache<K, V> delegate;

    public SecureCacheImpl(AdvancedCache<K, V> delegate) {
        this.authzManager = delegate.getAuthorizationManager();
        this.delegate = delegate;
    }

    @Override
    public boolean startBatch() {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.startBatch();
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener, filter, converter);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener, filter);
    }

    @Override
    public void addListener(Object listener) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener);
    }

    @Override
    public void start() {
        this.authzManager.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.authzManager.checkPermission(AuthorizationPermission.LIFECYCLE);
        this.delegate.stop();
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value);
    }

    @Override
    public void endBatch(boolean successful) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.endBatch(successful);
    }

    @Override
    public void removeListener(Object listener) {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        this.delegate.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        this.authzManager.checkPermission(AuthorizationPermission.LISTEN);
        return this.delegate.getListeners();
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, lifespan, unit);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return new SecureCacheImpl<K, V>(this.delegate.withFlags(flags));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getVersion() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getVersion();
    }

    @Override
    public V put(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.put(key, value);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.put(key, value, lifespan, unit);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.remove(key, value);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data, lifespan, unit);
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.addInterceptor(i, position);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsent(key, value, lifespan, unit);
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(map, lifespan, unit);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public NotifyingFuture<Void> clearAsync() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_WRITE);
        return this.delegate.clearAsync();
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, value, lifespan, unit);
    }

    @Override
    public void removeInterceptor(int position) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.removeInterceptor(position);
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.removeInterceptor(interceptorType);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, value, lifespan, unit);
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getInterceptorChain();
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, unit);
    }

    @Override
    public V replace(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, value);
    }

    @Override
    public EvictionManager getEvictionManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getEvictionManager();
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getExpirationManager();
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getComponentRegistry();
    }

    @Override
    public DistributionManager getDistributionManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getDistributionManager();
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getAuthorizationManager();
    }

    @Override
    public NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public boolean isEmpty() {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.isEmpty();
    }

    @Override
    public boolean lock(K ... keys) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.lock(keys);
    }

    @Override
    public boolean containsKey(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.containsKey(key);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.lock(keys);
    }

    @Override
    public NotifyingFuture<V> removeAsync(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.removeAsync(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.removeAsync(key, value);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.applyDelta(deltaAwareValueKey, delta, locksToAcquire);
    }

    @Override
    public void evict(K key) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.evict(key);
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value);
    }

    @Override
    public RpcManager getRpcManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getRpcManager();
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V get(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.get(key);
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value, lifespan, unit);
    }

    @Override
    public BatchContainer getBatchContainer() {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.getBatchContainer();
    }

    @Override
    public Configuration getCacheConfiguration() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getCacheConfiguration();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getCacheManager();
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getInvocationContextContainer();
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.delegate.getAvailability();
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        this.delegate.setAvailability(availabilityMode);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.cacheEntrySet();
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.removeExpired(key, value, lifespan);
    }

    @Override
    public int size() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.size();
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getDataContainer();
    }

    @Override
    public NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.delegate.getTransactionManager();
    }

    @Override
    public CacheSet<K> keySet() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.keySet();
    }

    @Override
    public V remove(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.remove(key);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.getAll(keys);
    }

    @Override
    public LockManager getLockManager() {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.getLockManager();
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue);
    }

    @Override
    public Stats getStats() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getStats();
    }

    @Override
    public XAResource getXAResource() {
        this.authzManager.checkPermission(AuthorizationPermission.ADMIN);
        return this.delegate.getXAResource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    @Override
    public CacheCollection<V> values() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.values();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return new SecureCacheImpl<K, V>(this.delegate.with(classLoader));
    }

    @Override
    public NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.entrySet();
    }

    @Override
    public NotifyingFuture<V> getAsync(K key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.getAsync(key);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.put(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(m, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        this.delegate.putAll(m);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, newValue, metadata);
    }

    @Override
    public void clear() {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_WRITE);
        this.delegate.clear();
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsent(key, value, metadata);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, metadata);
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        this.authzManager.checkPermission(AuthorizationPermission.READ);
        return this.delegate.getCacheEntry(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.getAllCacheEntries(keys);
    }

    @Override
    public EntryIterable<K, V> filterEntries(KeyValueFilter<? super K, ? super V> filter) {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.filterEntries(filter);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_READ);
        return this.delegate.getGroup(groupName);
    }

    @Override
    public void removeGroup(String groupName) {
        this.authzManager.checkPermission(AuthorizationPermission.BULK_WRITE);
        this.delegate.removeGroup(groupName);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return String.format("SecureCache '%s'", this.delegate.getName());
    }
}

