/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;

@Immutable
public class DefaultConsistentHash
implements ConsistentHash {
    private final Hash hashFunction;
    private final int numOwners;
    private final List<Address> members;
    private final float[] capacityFactors;
    private final List<Address>[] segmentOwners;
    private final int segmentSize;

    public DefaultConsistentHash(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors, List<Address>[] segmentOwners) {
        int i;
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        this.hashFunction = hashFunction;
        this.members = new ArrayList<Address>(members);
        if (capacityFactors == null) {
            this.capacityFactors = null;
        } else {
            this.capacityFactors = new float[members.size()];
            for (i = 0; i < this.capacityFactors.length; ++i) {
                this.capacityFactors[i] = capacityFactors.get(members.get(i)).floatValue();
            }
        }
        this.segmentOwners = new List[numSegments];
        for (i = 0; i < numSegments; ++i) {
            if (segmentOwners[i] == null || segmentOwners[i].isEmpty()) {
                throw new IllegalArgumentException("Segment owner list cannot be null or empty");
            }
            this.segmentOwners[i] = Immutables.immutableListCopy(segmentOwners[i]);
        }
        this.segmentSize = Util.getSegmentSize(numSegments);
    }

    private DefaultConsistentHash(Hash hashFunction, int numOwners, int numSegments, List<Address> members, float[] capacityFactors, List<Address>[] segmentOwners) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        if (numOwners < 1) {
            throw new IllegalArgumentException("The number of owners must be strictly positive");
        }
        this.numOwners = numOwners;
        this.hashFunction = hashFunction;
        this.members = members;
        this.capacityFactors = capacityFactors;
        for (int i = 0; i < numSegments; ++i) {
            if (segmentOwners[i] != null && segmentOwners[i].size() != 0) continue;
            throw new IllegalArgumentException("Segment owner list cannot be null or empty");
        }
        this.segmentOwners = segmentOwners;
        this.segmentSize = Util.getSegmentSize(numSegments);
    }

    @Override
    public Hash getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public int getNumSegments() {
        return this.segmentOwners.length;
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        HashSet<Integer> segments = new HashSet<Integer>();
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!this.segmentOwners[segment].contains(owner)) continue;
            segments.add(segment);
        }
        return segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.members.contains(owner)) {
            throw new IllegalArgumentException("Node " + owner + " is not a member");
        }
        HashSet<Integer> segments = new HashSet<Integer>();
        for (int segment = 0; segment < this.segmentOwners.length; ++segment) {
            if (!owner.equals(this.segmentOwners[segment].get(0))) continue;
            segments.add(segment);
        }
        return segments;
    }

    @Override
    public int getSegment(Object key) {
        return this.getNormalizedHash(key) / this.segmentSize;
    }

    public int getNormalizedHash(Object key) {
        return this.hashFunction.hash(key) & Integer.MAX_VALUE;
    }

    public List<Integer> getSegmentEndHashes() {
        int numSegments = this.segmentOwners.length;
        ArrayList<Integer> hashes = new ArrayList<Integer>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            hashes.add((i + 1) % numSegments * this.segmentSize);
        }
        return hashes;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.segmentOwners[segmentId];
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.segmentOwners[segmentId].get(0);
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public int getNumOwners() {
        return this.numOwners;
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.locatePrimaryOwnerForSegment(this.getSegment(key));
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.locateOwnersForSegment(this.getSegment(key));
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        HashSet<Integer> segments = new HashSet<Integer>();
        for (Object key : keys) {
            segments.add(this.getSegment(key));
        }
        HashSet<Address> ownersUnion = new HashSet<Address>();
        for (Integer segment : segments) {
            ownersUnion.addAll(this.segmentOwners[segment]);
        }
        return ownersUnion;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        int segment = this.getSegment(key);
        for (Address a : this.segmentOwners[segment]) {
            if (!a.equals(nodeAddress)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = this.numOwners;
        result = 31 * result + this.members.hashCode();
        result = 31 * result + Arrays.hashCode(this.segmentOwners);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConsistentHash that = (DefaultConsistentHash)o;
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.segmentOwners.length != that.segmentOwners.length) {
            return false;
        }
        if (!this.hashFunction.equals(that.hashFunction)) {
            return false;
        }
        if (!this.members.equals(that.members)) {
            return false;
        }
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            if (this.segmentOwners[i].equals(that.segmentOwners[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        OwnershipStatistics stats = new OwnershipStatistics(this, this.members);
        StringBuilder sb = new StringBuilder("DefaultConsistentHash{");
        sb.append("ns=").append(this.segmentOwners.length);
        sb.append(", owners = (").append(this.members.size()).append(")[");
        boolean first = true;
        for (Address a : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            int primaryOwned = stats.getPrimaryOwned(a);
            int owned = stats.getOwned(a);
            sb.append(a).append(": ").append(primaryOwned).append('+').append(owned - primaryOwned);
        }
        sb.append("]}");
        return sb.toString();
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.segmentOwners.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(i).append(":");
            for (int j = 0; j < this.segmentOwners[i].size(); ++j) {
                sb.append(' ').append(this.members.indexOf(this.segmentOwners[i].get(j)));
            }
        }
        return sb.toString();
    }

    public DefaultConsistentHash union(DefaultConsistentHash dch2) {
        if (!this.hashFunction.equals(dch2.getHashFunction())) {
            throw new IllegalArgumentException("The consistent hash objects must have the same hash function");
        }
        int numSegments = this.getNumSegments();
        if (numSegments != dch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        if (this.numOwners != dch2.getNumOwners()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of owners");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.members);
        this.mergeLists(unionMembers, dch2.getMembers());
        List[] unionSegmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            unionSegmentOwners[i] = new ArrayList<Address>(this.locateOwnersForSegment(i));
            this.mergeLists(unionSegmentOwners[i], dch2.locateOwnersForSegment(i));
        }
        HashMap<Address, Float> unionCapacityFactors = null;
        if (this.capacityFactors != null || dch2.capacityFactors != null) {
            unionCapacityFactors = new HashMap<Address, Float>();
            if (this.capacityFactors != null) {
                unionCapacityFactors.putAll(this.getCapacityFactors());
            } else {
                for (Address node : this.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
            if (dch2.capacityFactors != null) {
                unionCapacityFactors.putAll(dch2.getCapacityFactors());
            } else {
                for (Address node : dch2.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
        }
        return new DefaultConsistentHash(this.hashFunction, this.numOwners, numSegments, unionMembers, unionCapacityFactors, unionSegmentOwners);
    }

    private void mergeLists(List<Address> dest, List<Address> src) {
        for (Address node : src) {
            if (dest.contains(node)) continue;
            dest.add(node);
        }
    }

    public Map<Address, Float> getCapacityFactors() {
        if (this.capacityFactors == null) {
            return null;
        }
        HashMap<Address, Float> capacityFactorsMap = new HashMap<Address, Float>(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            capacityFactorsMap.put(this.members.get(i), Float.valueOf(this.capacityFactors[i]));
        }
        return capacityFactorsMap;
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<DefaultConsistentHash> {
        @Override
        public void doWriteObject(ObjectOutput output, DefaultConsistentHash ch) throws IOException {
            output.writeInt(ch.segmentOwners.length);
            output.writeInt(ch.numOwners);
            output.writeObject(ch.members);
            output.writeObject(ch.capacityFactors);
            output.writeObject(ch.hashFunction);
            HashMap<Address, Integer> memberIndexes = this.getMemberIndexMap(ch.members);
            for (int i = 0; i < ch.segmentOwners.length; ++i) {
                List owners = ch.segmentOwners[i];
                output.writeInt(owners.size());
                for (int j = 0; j < owners.size(); ++j) {
                    output.writeInt(memberIndexes.get(owners.get(j)));
                }
            }
        }

        @Override
        public DefaultConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int numSegments = unmarshaller.readInt();
            int numOwners = unmarshaller.readInt();
            List members = (List)unmarshaller.readObject();
            float[] capacityFactors = (float[])unmarshaller.readObject();
            Hash hash = (Hash)unmarshaller.readObject();
            List[] segmentOwners = new List[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                int size = unmarshaller.readInt();
                Address[] owners = new Address[size];
                for (int j = 0; j < size; ++j) {
                    int ownerIndex = unmarshaller.readInt();
                    owners[j] = (Address)members.get(ownerIndex);
                }
                segmentOwners[i] = Immutables.immutableListWrap(owners);
            }
            return new DefaultConsistentHash(hash, numOwners, numSegments, members, capacityFactors, segmentOwners);
        }

        private HashMap<Address, Integer> getMemberIndexMap(List<Address> members) {
            HashMap<Address, Integer> memberIndexes = new HashMap<Address, Integer>(members.size());
            for (int i = 0; i < members.size(); ++i) {
                memberIndexes.put(members.get(i), i);
            }
            return memberIndexes;
        }

        @Override
        public Integer getId() {
            return 51;
        }

        @Override
        public Set<Class<? extends DefaultConsistentHash>> getTypeClasses() {
            return Collections.singleton(DefaultConsistentHash.class);
        }
    }
}

