/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class SingletonStoreConfiguration {
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder("enabled", false).immutable().build();
    static final AttributeDefinition<Long> PUSH_STATE_TIMEOUT = AttributeDefinition.builder("pushStateTimeout", TimeUnit.SECONDS.toMillis(10L)).immutable().build();
    static final AttributeDefinition<Boolean> PUSH_STATE_WHEN_COORDINATOR = AttributeDefinition.builder("pushStateWhenCoordinator", true).immutable().build();
    private final Attribute<Boolean> enabled;
    private final Attribute<Long> pushStateTimeout;
    private final Attribute<Boolean> pushStateWhenCoordinator;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SingletonStoreConfiguration.class, ENABLED, PUSH_STATE_TIMEOUT, PUSH_STATE_WHEN_COORDINATOR);
    }

    SingletonStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.pushStateTimeout = attributes.attribute(PUSH_STATE_TIMEOUT);
        this.pushStateWhenCoordinator = attributes.attribute(PUSH_STATE_WHEN_COORDINATOR);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public long pushStateTimeout() {
        return this.pushStateTimeout.get();
    }

    public boolean pushStateWhenCoordinator() {
        return this.pushStateWhenCoordinator.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "SingletonStoreConfiguration [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingletonStoreConfiguration other = (SingletonStoreConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }
}

