/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

public class ReplicatedConsistentHash
implements ConsistentHash {
    private final Hash hashFunction;
    private final int[] primaryOwners;
    private final List<Address> members;
    private final Set<Address> membersSet;
    private final Set<Integer> segments;
    private final int segmentSize;

    public ReplicatedConsistentHash(Hash hashFunction, List<Address> members, int[] primaryOwners) {
        this.hashFunction = hashFunction;
        this.members = Collections.unmodifiableList(new ArrayList<Address>(members));
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(members));
        this.primaryOwners = primaryOwners;
        HashSet<Integer> segmentIds = new HashSet<Integer>(primaryOwners.length);
        for (int i = 0; i < primaryOwners.length; ++i) {
            segmentIds.add(i);
        }
        this.segments = Collections.unmodifiableSet(segmentIds);
        this.segmentSize = Util.getSegmentSize(primaryOwners.length);
    }

    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch2) {
        if (!this.getHashFunction().equals(ch2.getHashFunction())) {
            throw new IllegalArgumentException("The consistent hash objects must have the same hash function");
        }
        if (this.getNumSegments() != ch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.getMembers());
        for (Address member : ch2.getMembers()) {
            if (unionMembers.contains(member)) continue;
            unionMembers.add(member);
        }
        int[] primaryOwners = new int[this.getNumSegments()];
        for (int segmentId = 0; segmentId < primaryOwners.length; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
            primaryOwners[segmentId] = primaryOwnerIndex = unionMembers.indexOf(primaryOwner);
        }
        return new ReplicatedConsistentHash(this.getHashFunction(), unionMembers, primaryOwners);
    }

    @Override
    public int getNumSegments() {
        return this.primaryOwners.length;
    }

    @Override
    public int getNumOwners() {
        return this.members.size();
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public Hash getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public int getSegment(Object key) {
        return (this.hashFunction.hash(key) & Integer.MAX_VALUE) / this.segmentSize;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
        ArrayList<Address> owners = new ArrayList<Address>(this.members.size());
        owners.add(primaryOwner);
        for (Address member : this.members) {
            if (member.equals(primaryOwner)) continue;
            owners.add(member);
        }
        return owners;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(this.primaryOwners[segmentId]);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.membersSet.contains(owner)) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        return this.segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        int index = this.members.indexOf(owner);
        if (index == -1) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        HashSet<Integer> primarySegments = new HashSet<Integer>();
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            if (this.primaryOwners[i] != index) continue;
            primarySegments.add(i);
        }
        return primarySegments;
    }

    @Override
    public String getRoutingTableAsString() {
        return Arrays.toString(this.primaryOwners);
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.locatePrimaryOwnerForSegment(this.getSegment(key));
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.locateOwnersForSegment(this.getSegment(key));
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        return this.membersSet;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        return this.isSegmentLocalToNode(nodeAddress, 0);
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.membersSet.contains(nodeAddress);
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedConsistentHash{");
        sb.append("ns = ").append(this.segments.size());
        sb.append(", owners = (").append(this.members.size()).append(")[");
        int[] primaryOwned = new int[this.members.size()];
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            int n = this.primaryOwners[i];
            primaryOwned[n] = primaryOwned[n] + 1;
        }
        boolean first = true;
        for (int i = 0; i < this.members.size(); ++i) {
            Address a = this.members.get(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(a).append(": ").append(primaryOwned[i]);
        }
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashFunction == null ? 0 : this.hashFunction.hashCode());
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + Arrays.hashCode(this.primaryOwners);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicatedConsistentHash other = (ReplicatedConsistentHash)obj;
        if (this.hashFunction == null ? other.hashFunction != null : !this.hashFunction.equals(other.hashFunction)) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return Arrays.equals(this.primaryOwners, other.primaryOwners);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ReplicatedConsistentHash> {
        @Override
        public void doWriteObject(ObjectOutput output, ReplicatedConsistentHash ch) throws IOException {
            output.writeObject(ch.hashFunction);
            output.writeObject(ch.members);
            output.writeObject(ch.primaryOwners);
        }

        @Override
        public ReplicatedConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            Hash hashFunction = (Hash)unmarshaller.readObject();
            List members = (List)unmarshaller.readObject();
            int[] primaryOwners = (int[])unmarshaller.readObject();
            return new ReplicatedConsistentHash(hashFunction, members, primaryOwners);
        }

        @Override
        public Integer getId() {
            return 52;
        }

        @Override
        public Set<Class<? extends ReplicatedConsistentHash>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHash.class);
        }
    }

    public static class RangeSet
    implements Set<Integer> {
        final int size;

        public RangeSet(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size <= 0;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Integer)) {
                return false;
            }
            int i = (Integer)o;
            return 0 <= i && i < this.size;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new RangeSetIterator(this.size);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                array[i] = i;
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            for (int i = 0; i < this.size; ++i) {
                array[i] = i;
            }
            return array;
        }

        @Override
        public boolean add(Integer integer) {
            throw new UnsupportedOperationException("RangeSet is immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("RangeSet is immutable");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("RangeSet is immutable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("RangeSet is immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("RangeSet is immutable");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("RangeSet is immutable");
        }

        public String toString() {
            return "RangeSet(" + this.size + ")";
        }

        private static class RangeSetIterator
        implements Iterator<Integer> {
            private int size;
            private int next;

            public RangeSetIterator(int size) {
                this.size = size;
                this.next = 0;
            }

            @Override
            public boolean hasNext() {
                return this.next < this.size;
            }

            @Override
            public Integer next() {
                return this.next++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("RangeSet is read-only");
            }
        }
    }
}

