/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.configuration.ClusterConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.SecurityConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.marshall.Marshaller;

@BuiltBy(value=ConfigurationBuilder.class)
public class Configuration {
    private final ExecutorFactoryConfiguration asyncExecutorFactory;
    private final Class<? extends RequestBalancingStrategy> balancingStrategyClass;
    private final FailoverRequestBalancingStrategy balancingStrategy;
    private final WeakReference<ClassLoader> classLoader;
    private final ConnectionPoolConfiguration connectionPool;
    private final int connectionTimeout;
    private final Class<? extends ConsistentHash>[] consistentHashImpl;
    private final boolean forceReturnValues;
    private final int keySizeEstimate;
    private final Class<? extends Marshaller> marshallerClass;
    private final Marshaller marshaller;
    @Deprecated
    private final boolean pingOnStartup;
    private final String protocolVersion;
    private final List<ServerConfiguration> servers;
    private final int socketTimeout;
    private final SecurityConfiguration security;
    private final boolean tcpNoDelay;
    private final boolean tcpKeepAlive;
    private final Class<? extends TransportFactory> transportFactory;
    private final int valueSizeEstimate;
    private final int maxRetries;
    private final NearCacheConfiguration nearCache;
    private final List<ClusterConfiguration> clusters;
    private final List<String> serialWhitelist;

    Configuration(ExecutorFactoryConfiguration asyncExecutorFactory, Class<? extends RequestBalancingStrategy> balancingStrategyClass, FailoverRequestBalancingStrategy balancingStrategy, ClassLoader classLoader, ConnectionPoolConfiguration connectionPool, int connectionTimeout, Class<? extends ConsistentHash>[] consistentHashImpl, boolean forceReturnValues, int keySizeEstimate, Class<? extends Marshaller> marshallerClass, boolean pingOnStartup, String protocolVersion, List<ServerConfiguration> servers, int socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, Class<? extends TransportFactory> transportFactory, int valueSizeEstimate, int maxRetries, NearCacheConfiguration nearCache, List<ClusterConfiguration> clusters, List<String> serialWhitelist) {
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategyClass = balancingStrategyClass;
        this.balancingStrategy = balancingStrategy;
        this.maxRetries = maxRetries;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.connectionPool = connectionPool;
        this.connectionTimeout = connectionTimeout;
        this.consistentHashImpl = consistentHashImpl;
        this.forceReturnValues = forceReturnValues;
        this.keySizeEstimate = keySizeEstimate;
        this.marshallerClass = marshallerClass;
        this.marshaller = null;
        this.pingOnStartup = pingOnStartup;
        this.protocolVersion = protocolVersion;
        this.servers = Collections.unmodifiableList(servers);
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.transportFactory = transportFactory;
        this.valueSizeEstimate = valueSizeEstimate;
        this.nearCache = nearCache;
        this.clusters = clusters;
        this.serialWhitelist = serialWhitelist;
    }

    Configuration(ExecutorFactoryConfiguration asyncExecutorFactory, Class<? extends RequestBalancingStrategy> balancingStrategyClass, FailoverRequestBalancingStrategy balancingStrategy, ClassLoader classLoader, ConnectionPoolConfiguration connectionPool, int connectionTimeout, Class<? extends ConsistentHash>[] consistentHashImpl, boolean forceReturnValues, int keySizeEstimate, Marshaller marshaller, boolean pingOnStartup, String protocolVersion, List<ServerConfiguration> servers, int socketTimeout, SecurityConfiguration security, boolean tcpNoDelay, boolean tcpKeepAlive, Class<? extends TransportFactory> transportFactory, int valueSizeEstimate, int maxRetries, NearCacheConfiguration nearCache, List<ClusterConfiguration> clusters, List<String> serialWhitelist) {
        this.asyncExecutorFactory = asyncExecutorFactory;
        this.balancingStrategyClass = balancingStrategyClass;
        this.balancingStrategy = balancingStrategy;
        this.maxRetries = maxRetries;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.connectionPool = connectionPool;
        this.connectionTimeout = connectionTimeout;
        this.consistentHashImpl = consistentHashImpl;
        this.forceReturnValues = forceReturnValues;
        this.keySizeEstimate = keySizeEstimate;
        this.marshallerClass = null;
        this.marshaller = marshaller;
        this.pingOnStartup = pingOnStartup;
        this.protocolVersion = protocolVersion;
        this.servers = Collections.unmodifiableList(servers);
        this.socketTimeout = socketTimeout;
        this.security = security;
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.transportFactory = transportFactory;
        this.valueSizeEstimate = valueSizeEstimate;
        this.nearCache = nearCache;
        this.clusters = clusters;
        this.serialWhitelist = serialWhitelist;
    }

    public ExecutorFactoryConfiguration asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public Class<? extends RequestBalancingStrategy> balancingStrategyClass() {
        return this.balancingStrategyClass;
    }

    public FailoverRequestBalancingStrategy balancingStrategy() {
        return this.balancingStrategy;
    }

    public ClassLoader classLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    public ConnectionPoolConfiguration connectionPool() {
        return this.connectionPool;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public Class<? extends ConsistentHash>[] consistentHashImpl() {
        return this.consistentHashImpl;
    }

    public Class<? extends ConsistentHash> consistentHashImpl(int version) {
        return this.consistentHashImpl[version - 1];
    }

    public boolean forceReturnValues() {
        return this.forceReturnValues;
    }

    public int keySizeEstimate() {
        return this.keySizeEstimate;
    }

    public Marshaller marshaller() {
        return this.marshaller;
    }

    public Class<? extends Marshaller> marshallerClass() {
        return this.marshallerClass;
    }

    public NearCacheConfiguration nearCache() {
        return this.nearCache;
    }

    @Deprecated
    public boolean pingOnStartup() {
        return this.pingOnStartup;
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public List<ServerConfiguration> servers() {
        return this.servers;
    }

    public List<ClusterConfiguration> clusters() {
        return this.clusters;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public SecurityConfiguration security() {
        return this.security;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public Class<? extends TransportFactory> transportFactory() {
        return this.transportFactory;
    }

    public int valueSizeEstimate() {
        return this.valueSizeEstimate;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public List<String> serialWhitelist() {
        return this.serialWhitelist;
    }

    public String toString() {
        return "Configuration [asyncExecutorFactory=" + this.asyncExecutorFactory + ", balancingStrategyClass=" + this.balancingStrategyClass + ", balancingStrategy=" + this.balancingStrategy + ",classLoader=" + this.classLoader + ", connectionPool=" + this.connectionPool + ", connectionTimeout=" + this.connectionTimeout + ", consistentHashImpl=" + Arrays.toString(this.consistentHashImpl) + ", forceReturnValues=" + this.forceReturnValues + ", keySizeEstimate=" + this.keySizeEstimate + ", marshallerClass=" + this.marshallerClass + ", marshaller=" + this.marshaller + ", pingOnStartup=" + this.pingOnStartup + ", protocolVersion=" + this.protocolVersion + ", servers=" + this.servers + ", socketTimeout=" + this.socketTimeout + ", security=" + this.security + ", tcpNoDelay=" + this.tcpNoDelay + ", tcpKeepAlive=" + this.tcpKeepAlive + ", transportFactory=" + this.transportFactory + ", valueSizeEstimate=" + this.valueSizeEstimate + ", maxRetries=" + this.maxRetries + ", serialWhiteList=" + this.serialWhitelist + "nearCache=" + this.nearCache + "]";
    }
}

