/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.remoting.transport.Transport;

public class TransportConfiguration {
    static final AttributeDefinition<String> CLUSTER_NAME = AttributeDefinition.builder("clusterName", "ISPN").immutable().build();
    static final AttributeDefinition<String> MACHINE_ID = AttributeDefinition.builder("machineId", null, String.class).immutable().build();
    static final AttributeDefinition<String> RACK_ID = AttributeDefinition.builder("rackId", null, String.class).immutable().build();
    static final AttributeDefinition<String> SITE_ID = AttributeDefinition.builder("siteId", null, String.class).immutable().build();
    static final AttributeDefinition<String> NODE_NAME = AttributeDefinition.builder("nodeName", null, String.class).immutable().build();
    static final AttributeDefinition<Long> DISTRIBUTED_SYNC_TIMEOUT = AttributeDefinition.builder("distributedSyncTimeout", TimeUnit.MINUTES.toMillis(4L)).build();
    static final AttributeDefinition<Integer> INITIAL_CLUSTER_SIZE = AttributeDefinition.builder("initialClusterSize", -1).immutable().build();
    static final AttributeDefinition<Long> INITIAL_CLUSTER_TIMEOUT = AttributeDefinition.builder("initialClusterTimeout", TimeUnit.MINUTES.toMillis(1L)).build();
    static final AttributeDefinition<Transport> TRANSPORT = AttributeDefinition.builder("transport", null, Transport.class).copier(IdentityAttributeCopier.INSTANCE).immutable().build();
    static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder("properties", null, TypedProperties.class).initializer(new AttributeInitializer<TypedProperties>(){

        @Override
        public TypedProperties initialize() {
            return new TypedProperties();
        }
    }).immutable().build();
    private final Attribute<String> clusterName;
    private final Attribute<String> machineId;
    private final Attribute<String> rackId;
    private final Attribute<String> siteId;
    private final Attribute<String> nodeName;
    private final Attribute<Long> distributedSyncTimeout;
    private final Attribute<Integer> initialClusterSize;
    private final Attribute<Long> initialClusterTimeout;
    private final Attribute<Transport> transport;
    private final Attribute<TypedProperties> properties;
    private final AttributeSet attributes;
    private final ThreadPoolConfiguration transportThreadPool;
    private final ThreadPoolConfiguration remoteCommandThreadPool;
    private final ThreadPoolConfiguration totalOrderThreadPool;

    static AttributeSet attributeSet() {
        return new AttributeSet(TransportConfiguration.class, CLUSTER_NAME, MACHINE_ID, RACK_ID, SITE_ID, NODE_NAME, DISTRIBUTED_SYNC_TIMEOUT, INITIAL_CLUSTER_SIZE, INITIAL_CLUSTER_TIMEOUT, TRANSPORT, PROPERTIES);
    }

    TransportConfiguration(AttributeSet attributes, ThreadPoolConfiguration transportThreadPool, ThreadPoolConfiguration remoteCommandThreadPool, ThreadPoolConfiguration totalOrderThreadPool) {
        this.attributes = attributes.checkProtection();
        this.transportThreadPool = transportThreadPool;
        this.remoteCommandThreadPool = remoteCommandThreadPool;
        this.totalOrderThreadPool = totalOrderThreadPool;
        this.clusterName = attributes.attribute(CLUSTER_NAME);
        this.machineId = attributes.attribute(MACHINE_ID);
        this.rackId = attributes.attribute(RACK_ID);
        this.siteId = attributes.attribute(SITE_ID);
        this.distributedSyncTimeout = attributes.attribute(DISTRIBUTED_SYNC_TIMEOUT);
        this.initialClusterSize = attributes.attribute(INITIAL_CLUSTER_SIZE);
        this.initialClusterTimeout = attributes.attribute(INITIAL_CLUSTER_TIMEOUT);
        this.transport = attributes.attribute(TRANSPORT);
        this.nodeName = attributes.attribute(NODE_NAME);
        this.properties = attributes.attribute(PROPERTIES);
    }

    public String clusterName() {
        return this.clusterName.get();
    }

    public String machineId() {
        return this.machineId.get();
    }

    public String rackId() {
        return this.rackId.get();
    }

    public String siteId() {
        return this.siteId.get();
    }

    public long distributedSyncTimeout() {
        return this.distributedSyncTimeout.get();
    }

    public int initialClusterSize() {
        return this.initialClusterSize.get();
    }

    public long initialClusterTimeout() {
        return this.initialClusterTimeout.get();
    }

    public Transport transport() {
        return this.transport.get();
    }

    public String nodeName() {
        return this.nodeName.get();
    }

    @Deprecated
    public boolean strictPeerToPeer() {
        return false;
    }

    public TypedProperties properties() {
        return this.properties.get();
    }

    public boolean hasTopologyInfo() {
        return this.siteId() != null || this.rackId() != null || this.machineId() != null;
    }

    public ThreadPoolConfiguration transportThreadPool() {
        return this.transportThreadPool;
    }

    public ThreadPoolConfiguration remoteCommandThreadPool() {
        return this.remoteCommandThreadPool;
    }

    public ThreadPoolConfiguration totalOrderThreadPool() {
        return this.totalOrderThreadPool;
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "TransportConfiguration [attributes=" + this.attributes + ", transportThreadPool=" + this.transportThreadPool + ", remoteCommandThreadPool=" + this.remoteCommandThreadPool + ", totalOrderThreadPool=" + this.totalOrderThreadPool + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.remoteCommandThreadPool == null ? 0 : this.remoteCommandThreadPool.hashCode());
        result = 31 * result + (this.totalOrderThreadPool == null ? 0 : this.totalOrderThreadPool.hashCode());
        result = 31 * result + (this.transportThreadPool == null ? 0 : this.transportThreadPool.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransportConfiguration other = (TransportConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.remoteCommandThreadPool == null ? other.remoteCommandThreadPool != null : !this.remoteCommandThreadPool.equals(other.remoteCommandThreadPool)) {
            return false;
        }
        if (this.totalOrderThreadPool == null ? other.totalOrderThreadPool != null : !this.totalOrderThreadPool.equals(other.totalOrderThreadPool)) {
            return false;
        }
        return !(this.transportThreadPool == null ? other.transportThreadPool != null : !this.transportThreadPool.equals(other.transportThreadPool));
    }
}

