/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.configuration.SaslStrength;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;

public class AuthenticationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthenticationConfiguration> {
    private static final Log log = LogFactory.getLog(AuthenticationConfigurationBuilder.class);
    private CallbackHandler callbackHandler;
    private boolean enabled = false;
    private String serverName;
    private Map<String, String> saslProperties = new HashMap<String, String>();
    private String saslMechanism;
    private Subject clientSubject;

    public AuthenticationConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    public AuthenticationConfigurationBuilder callbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public AuthenticationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public AuthenticationConfigurationBuilder saslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this;
    }

    public AuthenticationConfigurationBuilder saslProperties(Map<String, String> saslProperties) {
        this.saslProperties = saslProperties;
        return this;
    }

    public AuthenticationConfigurationBuilder saslQop(SaslQop ... qop) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < qop.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(qop[i].toString());
        }
        this.saslProperties.put("javax.security.sasl.qop", s.toString());
        return this;
    }

    public AuthenticationConfigurationBuilder saslStrength(SaslStrength ... strength) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strength.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(strength[i].toString());
        }
        this.saslProperties.put("javax.security.sasl.strength", s.toString());
        return this;
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.clientSubject = clientSubject;
        return this;
    }

    @Override
    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.callbackHandler, this.clientSubject, this.enabled, this.saslMechanism, this.saslProperties, this.serverName);
    }

    @Override
    public Builder<?> read(AuthenticationConfiguration template) {
        this.callbackHandler = template.callbackHandler();
        this.clientSubject = template.clientSubject();
        this.enabled = template.enabled();
        this.saslMechanism = template.saslMechanism();
        this.saslProperties = template.saslProperties();
        this.serverName = template.serverName();
        return this;
    }

    @Override
    public void validate() {
        if (this.enabled) {
            if (this.callbackHandler == null && this.clientSubject == null) {
                throw log.invalidCallbackHandler();
            }
            if (this.saslMechanism == null) {
                throw log.invalidSaslMechanism(this.saslMechanism);
            }
        }
    }
}

