/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Listeners;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class WriteOnlyMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.WriteOnlyMap<K, V> {
    private static final Log log = LogFactory.getLog(WriteOnlyMapImpl.class);
    private final Params params;

    private WriteOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(functionalMap);
        this.params = params;
    }

    public static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return new WriteOnlyMapImpl<K, V>(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new WriteOnlyMapImpl<K, V>(params, functionalMap);
    }

    @Override
    public CompletableFuture<Void> eval(K key, Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked eval(k=%s, %s)", (Object)key, (Object)this.params);
        Param<Param.FutureMode> futureMode = this.params.get(0);
        WriteOnlyKeyCommand<K, V> cmd = this.fmap.cmdFactory().buildWriteOnlyKeyCommand(key, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.futureVoid(futureMode, ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> eval(K key, V value, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked eval(k=%s, v=%s, %s)", (Object)key, (Object)value, (Object)this.params);
        Param<Param.FutureMode> futureMode = this.params.get(0);
        WriteOnlyKeyValueCommand<K, V> cmd = this.fmap.cmdFactory().buildWriteOnlyKeyValueCommand(key, value, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.futureVoid(futureMode, ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> evalMany(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalMany(entries=%s, %s)", (Object)entries, (Object)this.params);
        Param<Param.FutureMode> futureMode = this.params.get(0);
        WriteOnlyManyEntriesCommand<? extends K, ? extends V> cmd = this.fmap.cmdFactory().buildWriteOnlyManyEntriesCommand(entries, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, entries.size());
        return this.futureVoid(futureMode, ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> evalMany(Set<? extends K> keys, Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalMany(keys=%s, %s)", (Object)keys, (Object)this.params);
        Param<Param.FutureMode> futureMode = this.params.get(0);
        WriteOnlyManyCommand<? extends K, V> cmd = this.fmap.cmdFactory().buildWriteOnlyManyCommand(keys, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, keys.size());
        return this.futureVoid(futureMode, ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> evalAll(Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalAll(%s)", (Object)this.params);
        Param<Param.FutureMode> futureMode = this.params.get(0);
        Set keys = this.fmap.cache.keySet();
        WriteOnlyManyCommand cmd = this.fmap.cmdFactory().buildWriteOnlyManyCommand(keys, f, this.params);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(true, keys.size());
        return this.futureVoid(futureMode, ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> truncate() {
        log.tracef("Invoked truncate(%s)", (Object)this.params);
        Param<Param.FutureMode> futureMode = this.params.get(0);
        return Params.withFuture(futureMode, this.fmap.asyncExec(), () -> {
            this.fmap.cache.clear();
            return null;
        });
    }

    CompletableFuture<Void> futureVoid(Param<Param.FutureMode> futureMode, InvocationContext ctx, VisitableCommand cmd) {
        return Params.withFuture(futureMode, this.fmap.asyncExec(), () -> {
            this.fmap.chain().invoke(ctx, cmd);
            return null;
        });
    }

    @Override
    public FunctionalMap.WriteOnlyMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return WriteOnlyMapImpl.create(this.params.addAll(ps), this.fmap);
    }

    @Override
    public Listeners.WriteListeners<K, V> listeners() {
        return this.fmap.notifier();
    }
}

