/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jgroups.util.AsciiString;

public class Bits {
    public static char makeChar(byte[] buf, int offset) {
        return (char)((buf[offset + 1] & 0xFF) + (buf[offset] << 8));
    }

    public static void writeChar(char c, byte[] buf, int offset) {
        buf[offset + 1] = (byte)c;
        buf[offset] = (byte)(c >>> 8);
    }

    public static char readChar(byte[] buf, int offset) {
        return Bits.makeChar(buf, offset);
    }

    public static short makeShort(byte a, byte b) {
        return (short)(a << 8 | b & 0xFF);
    }

    public static short makeShort(byte a) {
        return (short)(a & 0xFF);
    }

    public static void writeShort(short s, byte[] buf, int offset) {
        buf[offset + 1] = (byte)s;
        buf[offset] = (byte)(s >>> 8);
    }

    public static short readShort(byte[] buf, int offset) {
        return (short)((buf[offset + 1] & 0xFF) + (buf[offset] << 8));
    }

    public static void writeInt(int num, ByteBuffer buf) {
        if (num == 0) {
            buf.put((byte)0);
            return;
        }
        int bytes_needed = Bits.bytesRequiredFor(num);
        buf.put((byte)bytes_needed);
        for (int i = 0; i < bytes_needed; ++i) {
            buf.put(Bits.getByteAt(num, i));
        }
    }

    public static void writeInt(int num, DataOutput out) throws IOException {
        if (num == 0) {
            out.write(0);
            return;
        }
        int bytes_needed = Bits.bytesRequiredFor(num);
        out.write(bytes_needed);
        for (int i = 0; i < bytes_needed; ++i) {
            out.write(Bits.getByteAt(num, i));
        }
    }

    public static void writeInt(int num, byte[] buf, int offset) {
        buf[offset + 3] = (byte)num;
        buf[offset + 2] = (byte)(num >>> 8);
        buf[offset + 1] = (byte)(num >>> 16);
        buf[offset] = (byte)(num >>> 24);
    }

    public static void writeIntCompressed(int num, byte[] buf, int offset) {
        if (num == 0) {
            buf[offset] = 0;
            return;
        }
        int bytes_needed = Bits.bytesRequiredFor(num);
        buf[offset++] = bytes_needed;
        for (int i = 0; i < bytes_needed; ++i) {
            buf[offset++] = Bits.getByteAt(num, i);
        }
    }

    public static int readInt(ByteBuffer buf) {
        byte len = buf.get();
        if (len == 0) {
            return 0;
        }
        byte[] retval = new byte[len];
        buf.get(retval, 0, len);
        return Bits.makeInt(retval, 0, len);
    }

    public static int readInt(DataInput in) throws IOException {
        byte len = in.readByte();
        if (len == 0) {
            return 0;
        }
        byte[] buf = new byte[len];
        in.readFully(buf, 0, len);
        return Bits.makeInt(buf, 0, len);
    }

    public static int readInt(byte[] buf, int offset) {
        return (buf[offset + 3] & 0xFF) + ((buf[offset + 2] & 0xFF) << 8) + ((buf[offset + 1] & 0xFF) << 16) + (buf[offset] << 24);
    }

    public static int readIntCompressed(byte[] buf, int offset) {
        int len;
        if ((len = buf[offset++]) == 0) {
            return 0;
        }
        byte[] buffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = buf[offset++];
        }
        return Bits.makeInt(buffer, 0, len);
    }

    public static int size(int num) {
        return (byte)(num == 0 ? 1 : Bits.bytesRequiredFor(num) + 1);
    }

    public static void writeLong(long num, ByteBuffer buf) {
        if (num == 0L) {
            buf.put((byte)0);
            return;
        }
        int bytes_needed = Bits.bytesRequiredFor(num);
        buf.put((byte)bytes_needed);
        for (int i = 0; i < bytes_needed; ++i) {
            buf.put(Bits.getByteAt(num, i));
        }
    }

    public static void writeLong(long num, DataOutput out) throws IOException {
        if (num == 0L) {
            out.write(0);
            return;
        }
        int bytes_needed = Bits.bytesRequiredFor(num);
        out.write(bytes_needed);
        for (int i = 0; i < bytes_needed; ++i) {
            out.write(Bits.getByteAt(num, i));
        }
    }

    public static void writeLong(long num, byte[] buf, int offset) {
        buf[offset + 7] = (byte)num;
        buf[offset + 6] = (byte)(num >>> 8);
        buf[offset + 5] = (byte)(num >>> 16);
        buf[offset + 4] = (byte)(num >>> 24);
        buf[offset + 3] = (byte)(num >>> 32);
        buf[offset + 2] = (byte)(num >>> 40);
        buf[offset + 1] = (byte)(num >>> 48);
        buf[offset] = (byte)(num >>> 56);
    }

    public static void writeLongCompressed(long num, byte[] buf, int offset) {
        if (num == 0L) {
            buf[offset] = 0;
            return;
        }
        int bytes_needed = Bits.bytesRequiredFor(num);
        buf[offset++] = bytes_needed;
        for (int i = 0; i < bytes_needed; ++i) {
            buf[offset++] = Bits.getByteAt(num, i);
        }
    }

    public static long readLong(ByteBuffer buf) {
        byte len = buf.get();
        if (len == 0) {
            return 0L;
        }
        byte[] retval = new byte[len];
        buf.get(retval, 0, len);
        return Bits.makeLong(retval, 0, len);
    }

    public static long readLong(DataInput in) throws IOException {
        byte len = in.readByte();
        if (len == 0) {
            return 0L;
        }
        byte[] buf = new byte[len];
        in.readFully(buf, 0, len);
        return Bits.makeLong(buf, 0, len);
    }

    public static long readLong(byte[] buf, int offset) {
        return ((long)buf[offset + 7] & 0xFFL) + (((long)buf[offset + 6] & 0xFFL) << 8) + (((long)buf[offset + 5] & 0xFFL) << 16) + (((long)buf[offset + 4] & 0xFFL) << 24) + (((long)buf[offset + 3] & 0xFFL) << 32) + (((long)buf[offset + 2] & 0xFFL) << 40) + (((long)buf[offset + 1] & 0xFFL) << 48) + ((long)buf[offset] << 56);
    }

    public static long readLongCompressed(byte[] buf, int offset) {
        int len;
        if ((len = buf[offset++]) == 0) {
            return 0L;
        }
        byte[] buffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = buf[offset++];
        }
        return Bits.makeLong(buffer, 0, len);
    }

    public static int size(long num) {
        return (byte)(num == 0L ? 1 : Bits.bytesRequiredFor(num) + 1);
    }

    public static void writeLongSequence(long hd, long hr, ByteBuffer buf) {
        int i;
        if (hr < hd) {
            throw new IllegalArgumentException("hr (" + hr + ") has to be >= hd (" + hd + ")");
        }
        if (hd == 0L && hr == 0L) {
            buf.put((byte)0);
            return;
        }
        long delta = hr - hd;
        int bytes_for_hd = Bits.bytesRequiredFor(hd);
        int bytes_for_delta = Bits.bytesRequiredFor(delta);
        byte bytes_needed = Bits.encodeLength((byte)bytes_for_hd, (byte)bytes_for_delta);
        buf.put(bytes_needed);
        for (i = 0; i < bytes_for_hd; ++i) {
            buf.put(Bits.getByteAt(hd, i));
        }
        for (i = 0; i < bytes_for_delta; ++i) {
            buf.put(Bits.getByteAt(delta, i));
        }
    }

    public static void writeLongSequence(long hd, long hr, DataOutput out) throws IOException {
        int i;
        if (hr < hd) {
            throw new IllegalArgumentException("hr (" + hr + ") has to be >= hd (" + hd + ")");
        }
        if (hd == 0L && hr == 0L) {
            out.write(0);
            return;
        }
        long delta = hr - hd;
        int bytes_for_hd = Bits.bytesRequiredFor(hd);
        int bytes_for_delta = Bits.bytesRequiredFor(delta);
        byte bytes_needed = Bits.encodeLength((byte)bytes_for_hd, (byte)bytes_for_delta);
        out.write(bytes_needed);
        for (i = 0; i < bytes_for_hd; ++i) {
            out.write(Bits.getByteAt(hd, i));
        }
        for (i = 0; i < bytes_for_delta; ++i) {
            out.write(Bits.getByteAt(delta, i));
        }
    }

    public static long[] readLongSequence(ByteBuffer buf) {
        byte len = buf.get();
        if (len == 0) {
            return new long[]{0L, 0L};
        }
        byte[] lengths = Bits.decodeLength(len);
        long[] seqnos = new long[2];
        byte[] retval = new byte[lengths[0] + lengths[1]];
        buf.get(retval, 0, retval.length);
        seqnos[0] = Bits.makeLong(retval, 0, lengths[0]);
        seqnos[1] = Bits.makeLong(retval, lengths[0], lengths[1]) + seqnos[0];
        return seqnos;
    }

    public static long[] readLongSequence(DataInput in) throws IOException {
        byte len = in.readByte();
        if (len == 0) {
            return new long[]{0L, 0L};
        }
        byte[] lengths = Bits.decodeLength(len);
        long[] seqnos = new long[2];
        byte[] buf = new byte[lengths[0] + lengths[1]];
        in.readFully(buf, 0, buf.length);
        seqnos[0] = Bits.makeLong(buf, 0, lengths[0]);
        seqnos[1] = Bits.makeLong(buf, lengths[0], lengths[1]) + seqnos[0];
        return seqnos;
    }

    public static byte size(long hd, long hr) {
        if (hd == 0L && hr == 0L) {
            return 1;
        }
        byte num_bytes_for_hd = Bits.bytesRequiredFor(hd);
        byte num_bytes_for_delta = Bits.bytesRequiredFor(hr - hd);
        return (byte)(num_bytes_for_hd + num_bytes_for_delta + 1);
    }

    public static long makeLong(byte[] buf, int offset, int bytes_to_read) {
        long retval = 0L;
        for (int i = 0; i < bytes_to_read; ++i) {
            byte b = buf[offset + i];
            retval |= ((long)b & 0xFFL) << i * 8;
        }
        return retval;
    }

    public static int makeInt(byte[] buf, int offset, int bytes_to_read) {
        int retval = 0;
        for (int i = 0; i < bytes_to_read; ++i) {
            byte b = buf[offset + i];
            retval |= (b & 0xFF) << i * 8;
        }
        return retval;
    }

    public static void writeFloat(float num, ByteBuffer buf) {
        Bits.writeInt(Float.floatToIntBits(num), buf);
    }

    public static void writeFloat(float num, DataOutput out) throws IOException {
        Bits.writeInt(Float.floatToIntBits(num), out);
    }

    public static void writeFloat(float num, byte[] buf, int offset) {
        Bits.writeInt(Float.floatToIntBits(num), buf, offset);
    }

    public static float readFloat(ByteBuffer buf) {
        return Float.intBitsToFloat(Bits.readInt(buf));
    }

    public static float readFloat(DataInput in) throws IOException {
        return Float.intBitsToFloat(Bits.readInt(in));
    }

    public static float readFloat(byte[] buf, int offset) {
        return Float.intBitsToFloat(Bits.readInt(buf, offset));
    }

    public static int size(float num) {
        return Bits.size(Float.floatToIntBits(num));
    }

    public static void writeDouble(double num, ByteBuffer buf) {
        Bits.writeLong(Double.doubleToLongBits(num), buf);
    }

    public static void writeDouble(double num, DataOutput out) throws IOException {
        Bits.writeLong(Double.doubleToLongBits(num), out);
    }

    public static void writeDouble(double num, byte[] buf, int offset) {
        Bits.writeLong(Double.doubleToLongBits(num), buf, offset);
    }

    public static double readDouble(ByteBuffer buf) {
        return Double.longBitsToDouble(Bits.readLong(buf));
    }

    public static double readDouble(DataInput in) throws IOException {
        return Double.longBitsToDouble(Bits.readLong(in));
    }

    public static double readDouble(byte[] buf, int offset) {
        return Double.longBitsToDouble(Bits.readLong(buf, offset));
    }

    public static int size(double num) {
        return Bits.size(Double.doubleToLongBits(num));
    }

    public static void writeString(String s, ByteBuffer buf) {
        buf.put((byte)(s != null ? 1 : 0));
        if (s != null) {
            byte[] bytes = s.getBytes();
            Bits.writeInt(bytes.length, buf);
            buf.put(bytes);
        }
    }

    public static void writeString(String s, DataOutput out) throws IOException {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    public static String readString(ByteBuffer buf) {
        if (buf.get() == 0) {
            return null;
        }
        int len = Bits.readInt(buf);
        byte[] bytes = new byte[len];
        buf.get(bytes);
        return new String(bytes);
    }

    public static String readString(DataInput in) throws IOException {
        byte b = in.readByte();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static int sizeUTF(String str) {
        int len = str != null ? str.length() : 0;
        int utflen = 2;
        if (len == 0) {
            return utflen;
        }
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static int size(String str) {
        if (str == null) {
            return 1;
        }
        byte[] bytes = str.getBytes();
        return 1 + Bits.size(bytes.length) + bytes.length;
    }

    public static void writeAsciiString(AsciiString s, ByteBuffer buf) {
        short length = (short)(s != null ? s.length() : -1);
        buf.putShort(length);
        if (s != null) {
            buf.put(s.chars());
        }
    }

    public static void writeAsciiString(AsciiString s, DataOutput out) throws IOException {
        short length = (short)(s != null ? s.length() : -1);
        out.writeShort(length);
        if (s != null) {
            out.write(s.chars());
        }
    }

    public static AsciiString readAsciiString(ByteBuffer buf) {
        short len = buf.getShort();
        if (len < 0) {
            return null;
        }
        AsciiString retval = new AsciiString(len);
        buf.get(retval.chars());
        return retval;
    }

    public static AsciiString readAsciiString(DataInput in) throws IOException {
        short len = in.readShort();
        if (len < 0) {
            return null;
        }
        AsciiString retval = new AsciiString(len);
        in.readFully(retval.chars());
        return retval;
    }

    public static int size(AsciiString str) {
        return str == null ? 2 : 2 + str.length();
    }

    protected static byte encodeLength(byte len1, byte len2) {
        byte retval = len2;
        retval = (byte)(retval | len1 << 4);
        return retval;
    }

    protected static byte[] decodeLength(byte len) {
        return new byte[]{(byte)((len & 0xFF) >> 4), (byte)(len & 0xFFFFFF0F)};
    }

    protected static byte bytesRequiredFor(long number) {
        if (number >> 56 != 0L) {
            return 8;
        }
        if (number >> 48 != 0L) {
            return 7;
        }
        if (number >> 40 != 0L) {
            return 6;
        }
        if (number >> 32 != 0L) {
            return 5;
        }
        if (number >> 24 != 0L) {
            return 4;
        }
        if (number >> 16 != 0L) {
            return 3;
        }
        if (number >> 8 != 0L) {
            return 2;
        }
        return 1;
    }

    protected static byte bytesRequiredFor(int number) {
        if (number >> 24 != 0) {
            return 4;
        }
        if (number >> 16 != 0) {
            return 3;
        }
        if (number >> 8 != 0) {
            return 2;
        }
        return 1;
    }

    protected static byte getByteAt(long num, int index) {
        return (byte)(num >> index * 8);
    }
}

