/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoveCommand
extends AbstractDataWriteCommand {
    private static final Log log = LogFactory.getLog(RemoveCommand.class);
    public static final byte COMMAND_ID = 10;
    protected CacheNotifier notifier;
    boolean successful = true;
    boolean nonExistent = false;
    protected ValueMatcher valueMatcher;
    protected Equivalence valueEquivalence;
    protected Object value;

    public RemoveCommand(Object key, Object value, CacheNotifier notifier, Set<Flag> flags, Equivalence valueEquivalence, CommandInvocationId commandInvocationId) {
        super(key, flags, commandInvocationId);
        this.value = value;
        this.notifier = notifier;
        this.valueEquivalence = valueEquivalence;
        this.valueMatcher = value != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
    }

    public void init(CacheNotifier notifier, Configuration configuration) {
        this.notifier = notifier;
        this.valueEquivalence = configuration.dataContainer().valueEquivalence();
    }

    public RemoveCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null || e.isNull() || e.isRemoved()) {
            this.nonExistent = true;
            if (this.valueMatcher.matches(e, this.value, null, this.valueEquivalence)) {
                if (e != null) {
                    e.setChanged(true);
                    e.setRemoved(true);
                    e.setCreated(false);
                    if (this instanceof EvictCommand) {
                        e.setEvicted(true);
                    }
                }
                return this.isConditional() ? Boolean.valueOf(true) : null;
            }
            log.trace("Nothing to remove since the entry doesn't exist in the context or it is null");
            this.successful = false;
            return false;
        }
        if (!this.valueMatcher.matches(e, this.value, null, this.valueEquivalence)) {
            this.successful = false;
            return false;
        }
        if (this instanceof EvictCommand) {
            e.setEvicted(true);
        }
        return this.performRemove(e, ctx);
    }

    public void notify(InvocationContext ctx, Object removedValue, Metadata removedMetadata, boolean isPre) {
        this.notifier.notifyCacheEntryRemoved(this.key, removedValue, removedMetadata, isPre, ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 10;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RemoveCommand that = (RemoveCommand)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RemoveCommand{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", flags=" + this.flags + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.value != null;
    }

    public boolean isNonExistent() {
        return this.nonExistent;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        output.writeObject(this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.flags = (Set)input.readObject();
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.commandInvocationId = (CommandInvocationId)input.readObject();
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
        if (this.value != null) {
            this.successful = (Boolean)remoteResponse;
        }
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return this.value != null || !this.hasFlag(Flag.IGNORE_RETURN_VALUES);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return this.isConditional() || super.isReturnValueExpected();
    }

    protected Object performRemove(CacheEntry e, InvocationContext ctx) {
        Object removedValue = e.getValue();
        this.notify(ctx, removedValue, e.getMetadata(), true);
        e.setRemoved(true);
        e.setValid(false);
        e.setChanged(true);
        if (this.valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW) {
            return this.isConditional() ? Boolean.valueOf(true) : removedValue;
        }
        return this.isConditional() ? Boolean.valueOf(true) : this.value;
    }
}

