/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.stringbased;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.jdbc.table.management.TableManagerFactory;
import org.infinispan.persistence.keymappers.Key2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.UnsupportedKeyTypeException;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=JdbcStringBasedStoreConfiguration.class)
public class JdbcStringBasedStore
implements AdvancedLoadWriteStore {
    private static final Log log = LogFactory.getLog(JdbcStringBasedStore.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private JdbcStringBasedStoreConfiguration configuration;
    private Key2StringMapper key2StringMapper;
    private ConnectionFactory connectionFactory;
    private TableManager tableManager;
    private InitializationContext ctx;
    private String cacheName;
    private GlobalConfiguration globalConfiguration;

    @Override
    public void init(InitializationContext ctx) {
        this.configuration = (JdbcStringBasedStoreConfiguration)ctx.getConfiguration();
        this.ctx = ctx;
        this.cacheName = ctx.getCache().getName();
        this.globalConfiguration = ctx.getCache().getCacheManager().getCacheManagerConfiguration();
    }

    @Override
    public void start() {
        if (this.configuration.manageConnectionFactory()) {
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory(this.configuration.connectionFactory().connectionFactoryClass());
            factory.start(this.configuration.connectionFactory(), factory.getClass().getClassLoader());
            this.initializeConnectionFactory(factory);
        }
        try {
            Object mapper = Util.loadClassStrict(this.configuration.key2StringMapper(), this.globalConfiguration.classLoader()).newInstance();
            if (mapper instanceof Key2StringMapper) {
                this.key2StringMapper = (Key2StringMapper)mapper;
            }
        }
        catch (Exception e) {
            log.errorf("Trying to instantiate %s, however it failed due to %s", (Object)this.configuration.key2StringMapper(), (Object)e.getClass().getName());
            throw new IllegalStateException("This should not happen.", e);
        }
        if (trace) {
            log.tracef("Using key2StringMapper: %s", (Object)this.key2StringMapper.getClass().getName());
        }
        if (this.configuration.preload()) {
            this.enforceTwoWayMapper("preload");
        }
        if (this.isDistributed()) {
            this.enforceTwoWayMapper("distribution/rehashing");
        }
    }

    @Override
    public void stop() {
        Throwable cause = null;
        try {
            this.tableManager.stop();
        }
        catch (Throwable t) {
            cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        try {
            if (this.configuration.connectionFactory() instanceof ManagedConnectionFactory) {
                log.tracef("Stopping mananged connection factory: %s", (Object)this.connectionFactory);
                this.connectionFactory.stop();
            }
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug("Exception while stopping", t);
        }
        if (cause != null) {
            throw new PersistenceException("Exceptions occurred while stopping store", cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(MarshalledEntry entry) {
        Connection connection = null;
        PreparedStatement ps = null;
        String keyStr = this.key2Str(entry.getKey());
        try {
            connection = this.connectionFactory.getConnection();
            String sql = this.tableManager.getSelectIdRowSql();
            if (trace) {
                log.tracef("Running sql '%s'. Key string is '%s'", (Object)sql, (Object)keyStr);
            }
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            ResultSet rs = ps.executeQuery();
            sql = rs.next() ? this.tableManager.getUpdateRowSql() : this.tableManager.getInsertRowSql();
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            if (trace) {
                log.tracef("Running sql '%s'. Key string is '%s'", (Object)sql, (Object)keyStr);
            }
            ps = connection.prepareStatement(sql);
            this.updateStatement(entry, keyStr, ps);
            ps.executeUpdate();
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
            return;
        }
        catch (SQLException ex) {
            log.sqlFailureStoringKey(keyStr, ex);
            throw new PersistenceException(String.format("Error while storing string key to database; key: '%s'", keyStr), ex);
            catch (InterruptedException e) {
                if (trace) {
                    log.trace("Interrupted while marshalling to store");
                }
                Thread.currentThread().interrupt();
                return;
            }
        }
        finally {
            JdbcUtil.safeClose(ps);
            this.connectionFactory.releaseConnection(connection);
        }
    }

    @Override
    public MarshalledEntry load(Object key) {
        String lockingKey = this.key2Str(key);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        MarshalledEntry storedValue = null;
        try {
            String sql = this.tableManager.getSelectRowSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, lockingKey);
            rs = ps.executeQuery();
            if (rs.next()) {
                InputStream inputStream = rs.getBinaryStream(2);
                KeyValuePair icv = (KeyValuePair)JdbcUtil.unmarshall(this.ctx.getMarshaller(), inputStream);
                storedValue = this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, (ByteBuffer)icv.getKey(), (ByteBuffer)icv.getValue());
            }
        }
        catch (SQLException e) {
            try {
                log.sqlFailureReadingKey(key, lockingKey, e);
                throw new PersistenceException(String.format("SQL error while fetching stored entry with key: %s, lockingKey: %s", key, lockingKey), e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        if (storedValue != null && storedValue.getMetadata() != null && storedValue.getMetadata().isExpired(this.ctx.getTimeService().wallClockTime())) {
            return null;
        }
        return storedValue;
    }

    @Override
    public boolean delete(Object key) {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        String keyStr = this.key2Str(key);
        try {
            String sql = this.tableManager.getDeleteRowSql();
            if (trace) {
                log.tracef("Running sql '%s' on %s", (Object)sql, (Object)keyStr);
            }
            connection = this.connectionFactory.getConnection();
            ps = connection.prepareStatement(sql);
            ps.setString(1, keyStr);
            bl = ps.executeUpdate() == 1;
        }
        catch (SQLException ex) {
            try {
                log.sqlFailureRemovingKeys(ex);
                throw new PersistenceException("Error while removing string keys from database", ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(connection);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(connection);
        return bl;
    }

    @Override
    public void clear() throws PersistenceException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String sql = this.tableManager.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            ps = conn.prepareStatement(sql);
            int result = ps.executeUpdate();
            if (trace) {
                log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                log.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing cache store", ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
    }

    @Override
    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener task) {
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        Future<Void> future = ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Connection conn = null;
                PreparedStatement ps = null;
                try {
                    String sql = JdbcStringBasedStore.this.tableManager.getDeleteExpiredRowsSql();
                    conn = JdbcStringBasedStore.this.connectionFactory.getConnection();
                    ps = conn.prepareStatement(sql);
                    ps.setLong(1, JdbcStringBasedStore.this.ctx.getTimeService().wallClockTime());
                    int result = ps.executeUpdate();
                    if (trace) {
                        log.tracef("Successfully purged %d rows.", result);
                    }
                }
                catch (SQLException ex) {
                    try {
                        log.failedClearingJdbcCacheStore(ex);
                        throw new PersistenceException("Failed clearing string based JDBC store", ex);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(ps);
                        JdbcStringBasedStore.this.connectionFactory.releaseConnection(conn);
                        throw throwable;
                    }
                }
                JdbcUtil.safeClose(ps);
                JdbcStringBasedStore.this.connectionFactory.releaseConnection(conn);
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.errorExecutingParallelStoreTask(e);
            throw new PersistenceException(e);
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.load(key) != null;
    }

    @Override
    public void process(final KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, final boolean fetchValue, final boolean fetchMetadata) {
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(executor);
        Future<Void> future = ecs.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void void_;
                Connection conn = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    String sql = JdbcStringBasedStore.this.tableManager.getLoadNonExpiredAllRowsSql();
                    if (trace) {
                        log.tracef("Running sql %s", (Object)sql);
                    }
                    conn = JdbcStringBasedStore.this.connectionFactory.getConnection();
                    ps = conn.prepareStatement(sql, 1003, 1007);
                    ps.setLong(1, JdbcStringBasedStore.this.ctx.getTimeService().wallClockTime());
                    ps.setFetchSize(JdbcStringBasedStore.this.tableManager.getFetchSize());
                    rs = ps.executeQuery();
                    TaskContextImpl taskContext = new TaskContextImpl();
                    while (rs.next()) {
                        MarshalledEntry entry;
                        String keyStr = rs.getString(2);
                        Object key = ((TwoWayKey2StringMapper)JdbcStringBasedStore.this.key2StringMapper).getKeyMapping(keyStr);
                        if (taskContext.isStopped()) break;
                        if (filter != null && !filter.accept(key)) continue;
                        InputStream inputStream = rs.getBinaryStream(1);
                        if (fetchValue || fetchMetadata) {
                            KeyValuePair kvp = (KeyValuePair)JdbcUtil.unmarshall(JdbcStringBasedStore.this.ctx.getMarshaller(), inputStream);
                            entry = JdbcStringBasedStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, fetchValue ? (ByteBuffer)kvp.getKey() : null, fetchMetadata ? (ByteBuffer)kvp.getValue() : null);
                        } else {
                            entry = JdbcStringBasedStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, (Object)null, null);
                        }
                        task.processEntry(entry, taskContext);
                    }
                    void_ = null;
                }
                catch (SQLException e) {
                    try {
                        log.sqlFailureFetchingAllStoredEntries(e);
                        throw new PersistenceException("SQL error while fetching all StoredEntries", e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        JdbcUtil.safeClose(ps);
                        JdbcStringBasedStore.this.connectionFactory.releaseConnection(conn);
                        throw throwable;
                    }
                }
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                JdbcStringBasedStore.this.connectionFactory.releaseConnection(conn);
                return void_;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.errorExecutingParallelStoreTask(e);
            throw new PersistenceException(e);
        }
    }

    @Override
    public int size() {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.connectionFactory.getConnection();
            String sql = this.tableManager.getCountRowsSql();
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                log.sqlFailureIntegratingState(e);
                throw new PersistenceException("SQL failure while integrating state into store", e);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        this.connectionFactory.releaseConnection(conn);
        return n;
    }

    private void updateStatement(MarshalledEntry entry, String key, PreparedStatement ps) throws InterruptedException, SQLException {
        ByteBuffer byteBuffer = JdbcUtil.marshall(this.ctx.getMarshaller(), new KeyValuePair<ByteBuffer, ByteBuffer>(entry.getValueBytes(), entry.getMetadataBytes()));
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setLong(2, PersistenceUtil.getExpiryTime(entry.getMetadata()));
        ps.setString(3, key);
    }

    private String key2Str(Object key) throws PersistenceException {
        if (!this.key2StringMapper.isSupportedType(key.getClass())) {
            throw new UnsupportedKeyTypeException(key);
        }
        String keyStr = this.key2StringMapper.getStringMapping(key);
        return this.tableManager.isStringEncodingRequired() ? this.tableManager.encodeString(keyStr) : keyStr;
    }

    public boolean supportsKey(Class<?> keyType) {
        return this.key2StringMapper.isSupportedType(keyType);
    }

    public void initializeConnectionFactory(ConnectionFactory connectionFactory) throws PersistenceException {
        this.connectionFactory = connectionFactory;
        this.tableManager = TableManagerFactory.getManager(connectionFactory, this.configuration);
        this.tableManager.setCacheName(this.cacheName);
        this.tableManager.start();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public TableManager getTableManager() {
        return this.tableManager;
    }

    private void enforceTwoWayMapper(String where) throws PersistenceException {
        if (!(this.key2StringMapper instanceof TwoWayKey2StringMapper)) {
            log.invalidKey2StringMapper(where, this.key2StringMapper.getClass().getName());
            throw new PersistenceException(String.format("Invalid key to string mapper : %s", this.key2StringMapper.getClass().getName()));
        }
    }

    public boolean isDistributed() {
        return this.ctx.getCache().getCacheConfiguration() != null && this.ctx.getCache().getCacheConfiguration().clustering().cacheMode().isDistributed();
    }
}

