/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.ReplicableCommandManagerFunction;
import org.infinispan.manager.impl.ReplicableCommandRunnable;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.stream.impl.StreamSegmentResponseCommand;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteAdminCommand;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, byte type) {
        ReplicableCommand command;
        block27: {
            block26: {
                if (type != 0) break block26;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block27;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block27;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block27;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block27;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block27;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block27;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block27;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block27;
                    }
                    case 25: {
                        command = new ApplyDeltaCommand();
                        break block27;
                    }
                    case 17: {
                        command = new CacheTopologyControlCommand();
                        break block27;
                    }
                    case 43: {
                        command = new GetKeysInGroupCommand();
                        break block27;
                    }
                    case 45: {
                        command = new GetCacheEntryCommand();
                        break block27;
                    }
                    case 50: {
                        command = new ReadWriteKeyCommand();
                        break block27;
                    }
                    case 51: {
                        command = new ReadWriteKeyValueCommand();
                        break block27;
                    }
                    case 52: {
                        command = new ReadWriteManyCommand();
                        break block27;
                    }
                    case 53: {
                        command = new ReadWriteManyEntriesCommand();
                        break block27;
                    }
                    case 54: {
                        command = new WriteOnlyKeyCommand();
                        break block27;
                    }
                    case 55: {
                        command = new WriteOnlyKeyValueCommand();
                        break block27;
                    }
                    case 56: {
                        command = new WriteOnlyManyCommand();
                        break block27;
                    }
                    case 57: {
                        command = new WriteOnlyManyEntriesCommand();
                        break block27;
                    }
                    case 58: {
                        command = new RemoveExpiredCommand();
                        break block27;
                    }
                    case 59: {
                        command = new ReplicableCommandRunnable();
                        break block27;
                    }
                    case 60: {
                        command = new ReplicableCommandManagerFunction();
                        break block27;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        return command;
    }

    public CacheRpcCommand fromStream(byte id, byte type, ByteString cacheName) {
        CacheRpcCommand command;
        block36: {
            block35: {
                if (type != 0) break block35;
                switch (id) {
                    case 3: {
                        command = new LockControlCommand(cacheName);
                        break block36;
                    }
                    case 12: {
                        command = new PrepareCommand(cacheName);
                        break block36;
                    }
                    case 26: {
                        command = new VersionedPrepareCommand(cacheName);
                        break block36;
                    }
                    case 38: {
                        command = new TotalOrderNonVersionedPrepareCommand(cacheName);
                        break block36;
                    }
                    case 39: {
                        command = new TotalOrderVersionedPrepareCommand(cacheName);
                        break block36;
                    }
                    case 14: {
                        command = new CommitCommand(cacheName);
                        break block36;
                    }
                    case 27: {
                        command = new VersionedCommitCommand(cacheName);
                        break block36;
                    }
                    case 35: {
                        command = new TotalOrderCommitCommand(cacheName);
                        break block36;
                    }
                    case 36: {
                        command = new TotalOrderVersionedCommitCommand(cacheName);
                        break block36;
                    }
                    case 13: {
                        command = new RollbackCommand(cacheName);
                        break block36;
                    }
                    case 37: {
                        command = new TotalOrderRollbackCommand(cacheName);
                        break block36;
                    }
                    case 2: {
                        command = new MultipleRpcCommand(cacheName);
                        break block36;
                    }
                    case 1: {
                        command = new SingleRpcCommand(cacheName);
                        break block36;
                    }
                    case 16: {
                        command = new ClusteredGetCommand(cacheName);
                        break block36;
                    }
                    case 15: {
                        command = new StateRequestCommand(cacheName);
                        break block36;
                    }
                    case 20: {
                        command = new StateResponseCommand(cacheName);
                        break block36;
                    }
                    case 18: {
                        command = new RemoveCacheCommand(cacheName, this.cacheManager);
                        break block36;
                    }
                    case 22: {
                        command = new TxCompletionNotificationCommand(cacheName);
                        break block36;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand(cacheName);
                        break block36;
                    }
                    case 19: {
                        command = new DistributedExecuteCommand(cacheName);
                        break block36;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand(cacheName);
                        break block36;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand(cacheName);
                        break block36;
                    }
                    case 29: {
                        command = new CreateCacheCommand(cacheName);
                        break block36;
                    }
                    case 32: {
                        command = new XSiteAdminCommand(cacheName);
                        break block36;
                    }
                    case 34: {
                        command = new CancelCommand(cacheName);
                        break block36;
                    }
                    case 28: {
                        command = new XSiteStateTransferControlCommand(cacheName);
                        break block36;
                    }
                    case 33: {
                        command = new XSiteStatePushCommand(cacheName);
                        break block36;
                    }
                    case 40: {
                        command = new SingleXSiteRpcCommand(cacheName);
                        break block36;
                    }
                    case 46: {
                        command = new ClusteredGetAllCommand(cacheName);
                        break block36;
                    }
                    case 47: {
                        command = new StreamRequestCommand(cacheName);
                        break block36;
                    }
                    case 49: {
                        command = new StreamSegmentResponseCommand(cacheName);
                        break block36;
                    }
                    case 48: {
                        command = new StreamResponseCommand(cacheName);
                        break block36;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        return command;
    }
}

