/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1LastChanceInterceptor
extends BaseRpcInterceptor {
    private static final Log log = LogFactory.getLog(L1NonTxInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private L1Manager l1Manager;
    private ClusteringDependentLogic cdl;
    private Configuration configuration;
    private boolean nonTransactional;

    @Inject
    public void init(L1Manager l1Manager, ClusteringDependentLogic cdl, Configuration configuration) {
        this.l1Manager = l1Manager;
        this.cdl = cdl;
        this.configuration = configuration;
    }

    @Start
    public void start() {
        this.nonTransactional = this.configuration.transaction().transactionMode() == TransactionMode.NON_TRANSACTIONAL;
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command, true);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command, true);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.visitDataWriteCommand(ctx, command, false);
    }

    public CompletableFuture<Void> visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command, boolean assumeOriginKeptEntryInL1) throws Throwable {
        Object key;
        Object returnValue = ctx.forkInvocationSync(command);
        if (this.shouldUpdateOnWriteCommand(command) && command.isSuccessful() && this.cdl.localNodeIsOwner(key = command.getKey())) {
            if (trace) {
                log.trace("Sending additional invalidation for requestors if necessary.");
            }
            this.blockOnL1FutureIfNeeded(this.l1Manager.flushCache(Collections.singleton(key), ctx.getOrigin(), assumeOriginKeptEntryInL1));
        }
        return ctx.shortCircuit(returnValue);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = ctx.forkInvocationSync(command);
        if (this.shouldUpdateOnWriteCommand(command)) {
            Set<Object> keys = command.getMap().keySet();
            HashSet<Object> toInvalidate = new HashSet<Object>(keys.size());
            for (Object k : keys) {
                if (!this.cdl.localNodeIsOwner(k)) continue;
                toInvalidate.add(k);
            }
            if (!toInvalidate.isEmpty()) {
                if (trace) {
                    log.trace("Sending additional invalidation for requestors if necessary.");
                }
                this.blockOnL1FutureIfNeeded(this.l1Manager.flushCache(toInvalidate, ctx.getOrigin(), true));
            }
        }
        return ctx.shortCircuit(returnValue);
    }

    private boolean shouldUpdateOnWriteCommand(WriteCommand command) {
        return this.nonTransactional && !command.hasFlag(Flag.CACHE_MODE_LOCAL);
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = ctx.forkInvocationSync(command);
        if (command.isOnePhaseCommit()) {
            this.blockOnL1FutureIfNeededTx(this.handleLastChanceL1InvalidationOnCommit(ctx));
        }
        return ctx.shortCircuit(retVal);
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        Object retVal = ctx.forkInvocationSync(command);
        this.blockOnL1FutureIfNeededTx(this.handleLastChanceL1InvalidationOnCommit(ctx));
        return ctx.shortCircuit(retVal);
    }

    private Future<?> handleLastChanceL1InvalidationOnCommit(TxInvocationContext ctx) {
        if (this.shouldFlushL1(ctx)) {
            if (trace) {
                log.tracef("Sending additional invalidation for requestors if necessary.", new Object[0]);
            }
            return this.l1Manager.flushCache(ctx.getAffectedKeys(), ctx.getOrigin(), true);
        }
        return null;
    }

    private boolean shouldFlushL1(TxInvocationContext ctx) {
        return !ctx.getAffectedKeys().isEmpty();
    }

    private void blockOnL1FutureIfNeededTx(Future<?> f) {
        if (this.configuration.transaction().syncCommitPhase()) {
            this.blockOnL1FutureIfNeeded(f);
        }
    }

    private void blockOnL1FutureIfNeeded(Future<?> f) {
        block4: {
            if (f != null) {
                try {
                    f.get();
                }
                catch (InterruptedException e) {
                    this.getLog().failedInvalidatingRemoteCache(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof SuspectException) break block4;
                    this.getLog().failedInvalidatingRemoteCache(e);
                }
            }
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

