/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;

public abstract class BaseStateTransferInterceptor
extends DDSequentialInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    protected StateTransferManager stateTransferManager;
    private StateTransferLock stateTransferLock;
    private GroupManager groupManager;
    private long transactionDataTimeout;

    @Inject
    public void init(StateTransferLock stateTransferLock, Configuration configuration, StateTransferManager stateTransferManager, GroupManager groupManager) {
        this.stateTransferLock = stateTransferLock;
        this.stateTransferManager = stateTransferManager;
        this.groupManager = groupManager;
        this.transactionDataTimeout = configuration.clustering().remoteTimeout();
    }

    @Override
    public CompletableFuture<Void> visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        boolean isOwner = this.groupManager.isOwner(groupName);
        this.updateTopologyId(command);
        int commandTopologyId = command.getTopologyId();
        if (ctx.isOriginLocal()) {
            Object localResult;
            try {
                localResult = ctx.forkInvocationSync(command);
                if (isOwner && this.currentTopologyId() != commandTopologyId) {
                    return this.retryVisitGetKeysInGroupCommand(ctx, command, commandTopologyId);
                }
            }
            catch (CacheException e) {
                Throwable ce = e;
                while (ce instanceof RemoteException) {
                    ce = ce.getCause();
                }
                if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
                    throw e;
                }
                return this.retryVisitGetKeysInGroupCommand(ctx, command, commandTopologyId);
            }
            return ctx.shortCircuit(localResult);
        }
        Object result = ctx.forkInvocationSync(command);
        if (isOwner && this.currentTopologyId() != commandTopologyId) {
            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + this.currentTopologyId());
        }
        return ctx.shortCircuit(result);
    }

    protected final void logRetry(VisitableCommand command) {
        if (this.trace) {
            this.getLog().tracef("Retrying command because of topology change: %s", (Object)command);
        }
    }

    protected final int currentTopologyId() {
        CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
        return cacheTopology == null ? -1 : cacheTopology.getTopologyId();
    }

    protected final void waitForTransactionData(int topologyId) throws InterruptedException {
        this.stateTransferLock.waitForTransactionData(topologyId, this.transactionDataTimeout, TimeUnit.MILLISECONDS);
    }

    protected final void waitForTopology(int topologyId) throws InterruptedException {
        this.stateTransferLock.waitForTopology(topologyId, this.transactionDataTimeout, TimeUnit.MILLISECONDS);
    }

    protected final void updateTopologyId(TopologyAffectedCommand command) throws InterruptedException {
        CacheTopology cacheTopology;
        if (command.getTopologyId() == -1 && (cacheTopology = this.stateTransferManager.getCacheTopology()) != null) {
            command.setTopologyId(cacheTopology.getTopologyId());
        }
    }

    private CompletableFuture<Void> retryVisitGetKeysInGroupCommand(InvocationContext context, GetKeysInGroupCommand command, int commandTopologyId) throws Throwable {
        this.logRetry(command);
        int newTopologyId = Math.max(this.currentTopologyId(), commandTopologyId + 1);
        command.setTopologyId(newTopologyId);
        this.waitForTransactionData(newTopologyId);
        return this.visitGetKeysInGroupCommand(context, command);
    }

    protected abstract Log getLog();
}

