/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.remoting.transport.BackupResponse;

public class OptimisticBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return ctx.continueInvocation();
        }
        boolean isTxFromRemoteSite = this.isTxFromRemoteSite(command.getGlobalTransaction());
        if (isTxFromRemoteSite) {
            return ctx.continueInvocation();
        }
        BackupResponse backupResponse = this.backupSender.backupPrepare(command);
        Object result = ctx.forkInvocationSync(command);
        this.backupSender.processResponses(backupResponse, command, ctx.getTransaction());
        return ctx.shortCircuit(result);
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx)) {
            return ctx.continueInvocation();
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return ctx.continueInvocation();
        }
        BackupResponse backupResponse = this.backupSender.backupCommit(command);
        Object result = ctx.forkInvocationSync(command);
        this.backupSender.processResponses(backupResponse, command, ctx.getTransaction());
        return ctx.shortCircuit(result);
    }

    @Override
    public CompletableFuture<Void> visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.shouldRollbackRemoteTxCommand(ctx)) {
            return ctx.continueInvocation();
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return ctx.continueInvocation();
        }
        BackupResponse backupResponse = this.backupSender.backupRollback(command);
        Object result = ctx.forkInvocationSync(command);
        this.backupSender.processResponses(backupResponse, command, ctx.getTransaction());
        return ctx.shortCircuit(result);
    }

    private boolean shouldRollbackRemoteTxCommand(TxInvocationContext ctx) {
        return this.shouldInvokeRemoteTxCommand(ctx) && this.hasBeenPrepared((LocalTxInvocationContext)ctx);
    }

    private boolean hasBeenPrepared(LocalTxInvocationContext ctx) {
        return !ctx.getRemoteLocksAcquired().isEmpty();
    }
}

