/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.LocalFlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDSequentialInterceptor;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingInterceptor
extends DDSequentialInterceptor {
    private static final Log log = LogFactory.getLog(PartitionHandlingInterceptor.class);
    PartitionHandlingManager partitionHandlingManager;
    private Transport transport;
    private DistributionManager distributionManager;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager, Transport transport, DistributionManager distributionManager) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.transport = transport;
        this.distributionManager = distributionManager;
    }

    private boolean performPartitionCheck(InvocationContext ctx, LocalFlagAffectedCommand command) {
        if (!ctx.isOriginLocal()) {
            return true;
        }
        Set<Flag> flags = command.getFlags();
        return flags == null || !flags.contains((Object)Flag.CACHE_MODE_LOCAL);
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected CompletableFuture<Void> handleSingleWrite(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object result;
        Object key = command.getKey();
        try {
            result = ctx.forkInvocationSync(command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw log.degradedModeKeyUnavailable(key);
            }
            throw e;
        }
        this.postOperationPartitionCheck(ctx, command, key, result);
        return ctx.shortCircuit(result);
    }

    @Override
    public final CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        Object result;
        Object key = command.getKey();
        try {
            result = ctx.forkInvocationSync(command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw log.degradedModeKeyUnavailable(key);
            }
            throw e;
        }
        this.postOperationPartitionCheck(ctx, command, key, result);
        return ctx.shortCircuit(result);
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = ctx.forkInvocationSync(command);
        if (ctx.isOriginLocal()) {
            this.postTxCommandCheck(ctx);
        }
        return ctx.shortCircuit(result);
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        Object result = ctx.forkInvocationSync(command);
        if (ctx.isOriginLocal()) {
            this.postTxCommandCheck(ctx);
        }
        return ctx.shortCircuit(result);
    }

    protected void postTxCommandCheck(TxInvocationContext ctx) {
        if (ctx.hasModifications() && this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction())) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
    }

    private Object postOperationPartitionCheck(InvocationContext ctx, AbstractDataCommand command, Object key, Object result) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkRead(key);
            if (result == null && !InfinispanCollections.containsAny(this.transport.getMembers(), this.distributionManager.locate(key))) {
                throw log.degradedModeKeyUnavailable(key);
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        Map result;
        try {
            result = (Map)ctx.forkInvocationSync(command);
        }
        catch (RpcException e) {
            if (this.performPartitionCheck(ctx, command)) {
                throw log.degradedModeKeysUnavailable(command.getKeys());
            }
            throw e;
        }
        if (this.performPartitionCheck(ctx, command)) {
            for (Object key : command.getKeys()) {
                this.partitionHandlingManager.checkRead(key);
            }
            if (result.size() != command.getKeys().size()) {
                HashSet missingKeys = new HashSet(command.getKeys());
                missingKeys.removeAll(result.keySet());
                Iterator it = missingKeys.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (!InfinispanCollections.containsAny(this.transport.getMembers(), this.distributionManager.locate(key))) continue;
                    it.remove();
                }
                if (!missingKeys.isEmpty()) {
                    throw log.degradedModeKeysUnavailable(missingKeys);
                }
            }
        }
        return ctx.shortCircuit(result);
    }
}

