/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.BaseStateTransferInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AffectedKeysVisitor;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferInterceptor
extends BaseStateTransferInterceptor {
    private static final Log log = LogFactory.getLog(StateTransferInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    public static final Consumer<ConsistentHash> NOP = ch -> {};
    private StateTransferManager stateTransferManager;
    private final AffectedKeysVisitor affectedKeysVisitor = new AffectedKeysVisitor();

    @Inject
    public void init(StateTransferManager stateTransferManager) {
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public CompletableFuture<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return ctx.continueInvocation();
    }

    @Override
    public CompletableFuture<Void> visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitReadCommand(ctx, command, NOP);
    }

    @Override
    public CompletableFuture<Void> visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitReadCommand(ctx, command, NOP);
    }

    @Override
    public CompletableFuture<Void> visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.visitReadCommand(ctx, command, command::setConsistentHash);
    }

    private CompletableFuture<Void> visitReadCommand(InvocationContext ctx, FlagAffectedCommand command, Consumer<ConsistentHash> consistentHashUpdater) throws Throwable {
        if (this.isLocalOnly(command)) {
            return ctx.continueInvocation();
        }
        CacheTopology beginTopology = this.stateTransferManager.getCacheTopology();
        consistentHashUpdater.accept(beginTopology.getReadConsistentHash());
        this.updateTopologyId(command);
        try {
            return ctx.shortCircuit(ctx.forkInvocationSync(command));
        }
        catch (CacheException e) {
            Throwable ce = e;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
                throw e;
            }
            if (trace) {
                log.tracef("Retrying command because of topology change, current topology is %d: %s", this.currentTopologyId(), (Object)command);
            }
            int newTopologyId = Math.max(this.currentTopologyId(), command.getTopologyId() + 1);
            command.setTopologyId(newTopologyId);
            this.waitForTopology(newTopologyId);
            return this.visitReadCommand(ctx, command, consistentHashUpdater);
        }
    }

    @Override
    public CompletableFuture<Void> visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public CompletableFuture<Void> visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.visitReadCommand(ctx, command, command::setConsistentHash);
    }

    private CompletableFuture<Void> handleTxCommand(TxInvocationContext ctx, TransactionBoundaryCommand command) throws Throwable {
        Address origin;
        Address address = origin = ctx.isOriginLocal() ? ctx.getOrigin() : ctx.getGlobalTransaction().getAddress();
        if (trace) {
            log.tracef("handleTxCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(command)) {
            return ctx.continueInvocation();
        }
        this.updateTopologyId(command);
        int retryTopologyId = -1;
        Object localResult = null;
        try {
            localResult = ctx.forkInvocationSync(command);
        }
        catch (OutdatedTopologyException e) {
            retryTopologyId = Math.max(this.currentTopologyId(), command.getTopologyId() + 1);
        }
        boolean async = this.isTxCommandAsync(command);
        if (async) {
            this.stateTransferManager.forwardCommandIfNeeded(command, this.getAffectedKeys(ctx, command), origin);
            return ctx.shortCircuit(null);
        }
        if (ctx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                command.setTopologyId(retryTopologyId);
                this.waitForTransactionData(retryTopologyId);
                if (command instanceof PrepareCommand) {
                    ((PrepareCommand)command).setRetriedCommand(true);
                }
                log.tracef("Retrying command %s for topology %d", (Object)command, (Object)retryTopologyId);
                return this.handleTxCommand(ctx, command);
            }
        } else if (this.currentTopologyId() > command.getTopologyId()) {
            localResult = UnsureResponse.INSTANCE;
        }
        return ctx.shortCircuit(localResult);
    }

    private boolean isTxCommandAsync(TransactionBoundaryCommand command) {
        boolean async = false;
        if (command instanceof CommitCommand || command instanceof RollbackCommand) {
            async = !this.cacheConfiguration.transaction().syncCommitPhase();
        } else if (command instanceof PrepareCommand) {
            async = !this.cacheConfiguration.clustering().cacheMode().isSynchronous();
        }
        return async;
    }

    protected CompletableFuture<Void> handleWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.handleTxWriteCommand(ctx, command);
        }
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private CompletableFuture<Void> handleTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        Address origin = ctx.getOrigin();
        if (trace) {
            log.tracef("handleTxWriteCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(command)) {
            return ctx.continueInvocation();
        }
        this.updateTopologyId(command);
        int retryTopologyId = -1;
        Object localResult = null;
        try {
            localResult = ctx.forkInvocationSync(command);
        }
        catch (OutdatedTopologyException e) {
            retryTopologyId = Math.max(this.currentTopologyId(), command.getTopologyId() + 1);
        }
        if (ctx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                command.setTopologyId(retryTopologyId);
                this.waitForTransactionData(retryTopologyId);
                log.tracef("Retrying command %s for topology %d", (Object)command, (Object)retryTopologyId);
                return this.handleTxWriteCommand(ctx, command);
            }
        } else if (this.currentTopologyId() > command.getTopologyId()) {
            return ctx.shortCircuit(UnsureResponse.INSTANCE);
        }
        return ctx.shortCircuit(localResult);
    }

    private CompletableFuture<Void> handleNonTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (trace) {
            log.tracef("handleNonTxWriteCommand for command %s, topology id %d", (Object)command, (Object)command.getTopologyId());
        }
        if (this.isLocalOnly(command)) {
            return ctx.continueInvocation();
        }
        this.updateTopologyId(command);
        if (!ctx.isOriginLocal()) {
            return ctx.continueInvocation();
        }
        int commandTopologyId = command.getTopologyId();
        try {
            return ctx.shortCircuit(ctx.forkInvocationSync(command));
        }
        catch (CacheException e) {
            Throwable ce = e;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
                throw e;
            }
            int currentTopologyId = this.currentTopologyId();
            if (trace) {
                log.tracef("Retrying command because of topology change, current topology is %d: %s", currentTopologyId, (Object)command);
            }
            int newTopologyId = Math.max(currentTopologyId, commandTopologyId + 1);
            command.setTopologyId(newTopologyId);
            this.waitForTransactionData(newTopologyId);
            command.addFlag(Flag.COMMAND_RETRY);
            return this.handleNonTxWriteCommand(ctx, command);
        }
    }

    @Override
    public CompletableFuture<Void> handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof TopologyAffectedCommand) {
            return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin());
        }
        return ctx.continueInvocation();
    }

    private CompletableFuture<Void> handleTopologyAffectedCommand(InvocationContext ctx, VisitableCommand command, Address origin) throws Throwable {
        if (trace) {
            log.tracef("handleTopologyAffectedCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(command)) {
            return ctx.continueInvocation();
        }
        this.updateTopologyId((TopologyAffectedCommand)((Object)command));
        return ctx.continueInvocation();
    }

    private boolean isLocalOnly(VisitableCommand command) {
        boolean cacheModeLocal = false;
        if (command instanceof FlagAffectedCommand) {
            cacheModeLocal = ((FlagAffectedCommand)command).hasFlag(Flag.CACHE_MODE_LOCAL);
        }
        return cacheModeLocal;
    }

    private Set<Object> getAffectedKeys(InvocationContext ctx, VisitableCommand command) {
        Set affectedKeys = null;
        try {
            affectedKeys = (Set)command.acceptVisitor(ctx, this.affectedKeysVisitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (affectedKeys == null) {
            affectedKeys = Collections.emptySet();
        }
        return affectedKeys;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

