/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateResponseCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(StateResponseCommand.class);
    public static final byte COMMAND_ID = 20;
    private int topologyId;
    private Collection<StateChunk> stateChunks;
    private StateConsumer stateConsumer;

    private StateResponseCommand() {
        super(null);
    }

    public StateResponseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StateResponseCommand(ByteString cacheName, Address origin, int topologyId, Collection<StateChunk> stateChunks) {
        super(cacheName);
        this.setOrigin(origin);
        this.topologyId = topologyId;
        this.stateChunks = stateChunks;
    }

    public void init(StateConsumer stateConsumer) {
        this.stateConsumer = stateConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            this.stateConsumer.applyState(this.getOrigin(), this.topologyId, this.stateChunks);
            Object var3_3 = null;
            return var3_3;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public byte getCommandId() {
        return 20;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeInt(this.topologyId);
        MarshallUtil.marshallCollection(this.stateChunks, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.topologyId = input.readInt();
        this.stateChunks = MarshallUtil.unmarshallCollection(input, ArrayList::new);
    }

    @Override
    public String toString() {
        return "StateResponseCommand{cache=" + this.cacheName + ", stateChunks=" + this.stateChunks + ", origin=" + this.getOrigin() + ", topologyId=" + this.topologyId + '}';
    }
}

