/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockControlCommand
extends AbstractTransactionBoundaryCommand
implements FlagAffectedCommand,
TopologyAffectedCommand,
TransactionalRemoteLockCommand {
    private static final Log log = LogFactory.getLog(LockControlCommand.class);
    public static final int COMMAND_ID = 3;
    private List<Object> keys;
    private boolean unlock = false;
    private long flags = 0L;

    private LockControlCommand() {
        super(null);
    }

    public LockControlCommand(ByteString cacheName) {
        super(cacheName);
    }

    public LockControlCommand(Collection<?> keys, ByteString cacheName, long flags, GlobalTransaction gtx) {
        super(cacheName);
        this.keys = keys != null ? new ArrayList(keys) : Collections.emptyList();
        this.flags = flags;
        this.globalTx = gtx;
    }

    public LockControlCommand(Object key, ByteString cacheName, long flags, GlobalTransaction gtx) {
        this(cacheName);
        this.keys = new ArrayList<Object>(1);
        this.keys.add(key);
        this.flags = flags;
        this.globalTx = gtx;
    }

    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.globalTx = gtx;
    }

    public Collection<Object> getKeys() {
        return this.keys;
    }

    public void replaceKey(Object oldKey, Object replacement) {
        int i = this.keys.indexOf(oldKey);
        if (i >= 0) {
            this.keys.set(i, replacement);
        }
    }

    public void replaceKeys(Map<Object, Object> replacements) {
        for (int i = 0; i < this.keys.size(); ++i) {
            Object replacement = replacements.get(this.keys.get(i));
            if (replacement == null) continue;
            this.keys.set(i, replacement);
        }
    }

    public boolean multipleKeys() {
        return this.keys.size() > 1;
    }

    public Object getSingleKey() {
        if (this.keys.size() == 0) {
            return null;
        }
        return this.keys.get(0);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitLockControlCommand((TxInvocationContext)ctx, this);
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        RemoteTxInvocationContext ctx = this.createContext();
        if (ctx == null) {
            return CompletableFutures.completedNull();
        }
        return this.invoker.invokeAsync(ctx, this);
    }

    public RemoteTxInvocationContext createContext() {
        RemoteTransaction transaction = this.txTable.getRemoteTransaction(this.globalTx);
        if (transaction == null) {
            if (this.unlock) {
                log.tracef("Unlock for missing transaction %s.  Not doing anything.", (Object)this.globalTx);
                return null;
            }
            transaction = this.txTable.getOrCreateRemoteTransaction(this.globalTx, null);
        }
        return this.icf.createRemoteTxInvocationContext(transaction, this.getOrigin());
    }

    @Override
    public byte getCommandId() {
        return 3;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        output.writeBoolean(this.unlock);
        MarshallUtil.marshallCollection(this.keys, output);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.flags));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.unlock = input.readBoolean();
        this.keys = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.flags = input.readLong();
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LockControlCommand that = (LockControlCommand)o;
        if (this.unlock != that.unlock) {
            return false;
        }
        if (this.flags != that.flags) {
            return false;
        }
        return this.keys.equals(that.keys);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.keys.hashCode();
        result = 31 * result + (this.unlock ? 1 : 0);
        result = 31 * result + (int)(this.flags ^ this.flags >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "LockControlCommand{cache=" + this.cacheName + ", keys=" + this.keys + ", flags=" + EnumUtil.prettyPrintBitSet(this.flags, Flag.class) + ", unlock=" + this.unlock + ", gtx=" + this.globalTx + "}";
    }

    @Override
    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void setFlagsBitSet(long bitSet) {
        this.flags = bitSet;
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.unlock ? Collections.emptyList() : Collections.unmodifiableCollection(this.keys);
    }

    @Override
    public Object getKeyLockOwner() {
        return this.globalTx;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasFlag(Flag.SKIP_LOCKING);
    }
}

