/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class ExceptionAckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 42;
    private CommandInvocationId commandInvocationId;
    private CommandAckCollector commandAckCollector;
    private Throwable throwable;
    private int topologyId;

    public ExceptionAckCommand() {
        super(null);
    }

    public ExceptionAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public ExceptionAckCommand(ByteString cacheName, CommandInvocationId commandInvocationId, Throwable throwable, int topologyId) {
        super(cacheName);
        this.commandInvocationId = commandInvocationId;
        this.throwable = throwable;
        this.topologyId = topologyId;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.commandAckCollector.completeExceptionally(this.commandInvocationId, this.throwable, this.topologyId);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 42;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.throwable);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.throwable = (Throwable)input.readObject();
        this.topologyId = input.readInt();
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    @Override
    public String toString() {
        return "ExceptionAckCommand{commandInvocationId=" + this.commandInvocationId + ", throwable=" + this.throwable + ", topologyId=" + this.topologyId + '}';
    }
}

