/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import org.infinispan.commons.equivalence.Equivalence;

public enum ValueMatcher {
    MATCH_ALWAYS{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return true;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_ALWAYS;
        }
    }
    ,
    MATCH_EXPECTED{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return this.equal(existingValue, expectedValue, valueEquivalence);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NEW;
        }
    }
    ,
    MATCH_EXPECTED_OR_NEW{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return this.equal(existingValue, expectedValue, valueEquivalence) || this.equal(existingValue, newValue, valueEquivalence);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NEW;
        }
    }
    ,
    MATCH_EXPECTED_OR_NULL{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return newValue == null || this.equal(existingValue, expectedValue, valueEquivalence);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NULL;
        }
    }
    ,
    MATCH_NON_NULL{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return existingValue != null;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return false;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_ALWAYS;
        }
    }
    ,
    MATCH_NEVER{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return false;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return false;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_NEVER;
        }
    };

    private static final ValueMatcher[] CACHED_VALUES;

    public abstract boolean matches(Object var1, Object var2, Object var3, Equivalence var4);

    public abstract boolean nonExistentEntryCanMatch();

    public abstract ValueMatcher matcherForRetry();

    protected boolean equal(Object a, Object b, Equivalence valueEquivalence) {
        if (a == b) {
            return true;
        }
        return valueEquivalence != null ? valueEquivalence.equals(a, b) : a != null && a.equals(b);
    }

    public static ValueMatcher valueOf(int ordinal) {
        return CACHED_VALUES[ordinal];
    }

    static {
        CACHED_VALUES = ValueMatcher.values();
    }
}

