/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnsafeHolder;
import org.infinispan.factories.annotations.Inject;
import sun.misc.Unsafe;

public class UnpooledOffHeapMemoryAllocator
implements OffHeapMemoryAllocator {
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    private final AtomicLong amountAllocated = new AtomicLong();
    private LongUnaryOperator sizeCalculator;

    @Inject
    public void inject(OffHeapEntryFactory offHeapEntryFactory) {
        this.sizeCalculator = offHeapEntryFactory::determineSize;
    }

    @Override
    public long allocate(long memoryLength) {
        long memoryLocation = UNSAFE.allocateMemory(memoryLength);
        this.amountAllocated.addAndGet(memoryLength);
        return memoryLocation;
    }

    @Override
    public void deallocate(long memoryAddress) {
        this.amountAllocated.addAndGet(-this.sizeCalculator.applyAsLong(memoryAddress));
        UNSAFE.freeMemory(memoryAddress);
    }

    @Override
    public long getAllocatedAmount() {
        return this.amountAllocated.get();
    }
}

