/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.util.Experimental;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.AbstractInvocationStage;
import org.infinispan.interceptors.impl.AsyncInvocationStage;
import org.infinispan.interceptors.impl.ComposedAsyncInvocationStage;
import org.infinispan.interceptors.impl.ExceptionStage;
import org.infinispan.interceptors.impl.ReturnValueStage;
import org.infinispan.util.concurrent.CompletableFutures;

@Experimental
public abstract class BaseAsyncInterceptor
implements AsyncInterceptor {
    protected Configuration cacheConfiguration;
    private AsyncInterceptor nextInterceptor;

    @Inject
    public void inject(Configuration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    @Override
    public final void setNextInterceptor(AsyncInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public InvocationStage invokeNext(InvocationContext ctx, VisitableCommand command) {
        try {
            BasicInvocationStage stage = this.nextInterceptor.visitCommand(ctx, command);
            return stage.toInvocationStage(ctx, command);
        }
        catch (Throwable throwable) {
            return new ExceptionStage(ctx, command, throwable);
        }
    }

    public BasicInvocationStage returnWith(Object returnValue) {
        return new ReturnValueStage(null, null, returnValue);
    }

    public InvocationStage goAsync(CompletableFuture<BasicInvocationStage> stageFuture) {
        if (stageFuture.isDone()) {
            AbstractInvocationStage stage;
            try {
                stage = (AbstractInvocationStage)stageFuture.join();
            }
            catch (Throwable t) {
                stage = new ExceptionStage(null, null, CompletableFutures.extractException(t));
            }
            return stage;
        }
        return new ComposedAsyncInvocationStage(null, null, stageFuture);
    }

    public InvocationStage invokeNextAsync(InvocationContext ctx, VisitableCommand command, CompletableFuture<?> delay) {
        if (delay.isDone()) {
            InvocationStage stage;
            try {
                delay.join();
                stage = this.invokeNext(ctx, command);
            }
            catch (Throwable t) {
                stage = new ExceptionStage(ctx, command, CompletableFutures.extractException(t));
            }
            return stage;
        }
        CompletionStage stageFuture = delay.thenApply(o -> this.invokeNext(ctx, command));
        return new ComposedAsyncInvocationStage(ctx, command, (CompletableFuture<BasicInvocationStage>)stageFuture);
    }

    public BasicInvocationStage returnWithAsync(CompletableFuture<Object> valueFuture) {
        if (valueFuture.isDone()) {
            AbstractInvocationStage stage;
            try {
                Object value = valueFuture.join();
                stage = new ReturnValueStage(null, null, value);
            }
            catch (Throwable t) {
                stage = new ExceptionStage(null, null, CompletableFutures.extractException(t));
            }
            return stage;
        }
        return new AsyncInvocationStage(null, null, valueFuture);
    }
}

