/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredCacheLoaderInterceptor
extends CacheLoaderInterceptor {
    private static final Log log = LogFactory.getLog(ClusteredCacheLoaderInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean transactional;
    private ClusteringDependentLogic cdl;
    private StateTransferManager stateTransferManager;
    private boolean distributed;

    @Inject
    private void injectDependencies(ClusteringDependentLogic cdl, StateTransferManager stateTransferManager) {
        this.cdl = cdl;
        this.stateTransferManager = stateTransferManager;
    }

    @Start(priority=15)
    private void startClusteredCacheLoaderInterceptor() {
        this.transactional = this.cacheConfiguration.transaction().transactionMode().isTransactional();
        this.distributed = this.cacheConfiguration.clustering().cacheMode().isDistributed();
    }

    @Override
    protected boolean skipLoadForWriteCommand(WriteCommand cmd, Object key, InvocationContext ctx) {
        if (this.transactional) {
            if (!ctx.isOriginLocal() && cmd.loadType() != VisitableCommand.LoadType.OWNER) {
                return true;
            }
        } else {
            switch (cmd.loadType()) {
                case DONT_LOAD: {
                    return true;
                }
                case PRIMARY: {
                    if (cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                        return cmd.hasFlag(Flag.SKIP_CACHE_LOAD);
                    }
                    if (this.cdl.localNodeIsPrimaryOwner(key)) break;
                    if (trace) {
                        log.tracef("Skip load for command %s. This node is not the primary owner of %s", (Object)cmd, (Object)Util.toStr(key));
                    }
                    return true;
                }
                case OWNER: {
                    int index;
                    if (cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                        return cmd.hasFlag(Flag.SKIP_CACHE_LOAD);
                    }
                    List<Address> owners = this.cdl.getOwners(key);
                    int n = index = owners == null ? 0 : owners.indexOf(this.cdl.getAddress());
                    if (index == 0 || index >= 0 && !ctx.isOriginLocal()) break;
                    if (trace) {
                        log.tracef("Skip load for command %s. This node is neither the primary owner nor non-origin backup of %s", (Object)cmd, (Object)Util.toStr(key));
                    }
                    return true;
                }
            }
        }
        return super.skipLoadForWriteCommand(cmd, key, ctx);
    }

    @Override
    protected boolean canLoad(Object key) {
        return this.stateTransferManager.isJoinComplete() && (!this.distributed || this.isKeyLocal(key));
    }

    private boolean isKeyLocal(Object key) {
        return this.stateTransferManager.getCacheTopology().getReadConsistentHash().isKeyLocalToNode(this.cdl.getAddress(), key);
    }
}

