/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.TableManager;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.TransactionalCacheWriter;

public abstract class AbstractJdbcStore<K, V>
implements AdvancedLoadWriteStore<K, V>,
TransactionalCacheWriter<K, V> {
    private final Map<Transaction, Connection> transactionConnectionMap = new ConcurrentHashMap<Transaction, Connection>();
    private final Log log;
    private AbstractJdbcStoreConfiguration configuration;
    protected ConnectionFactory connectionFactory;
    protected TableManager tableManager;
    protected InitializationContext ctx;
    protected String cacheName;

    protected abstract TableManager getTableManager();

    protected AbstractJdbcStore(Log log) {
        this.log = log;
    }

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (AbstractJdbcStoreConfiguration)ctx.getConfiguration();
        this.cacheName = ctx.getCache().getName();
    }

    @Override
    public void start() {
        if (this.configuration.manageConnectionFactory()) {
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory(this.configuration.connectionFactory().connectionFactoryClass());
            factory.start(this.configuration.connectionFactory(), factory.getClass().getClassLoader());
            this.initializeConnectionFactory(factory);
        }
    }

    @Override
    public void stop() {
        Throwable cause = null;
        try {
            this.tableManager.stop();
            this.tableManager = null;
        }
        catch (Throwable t) {
            cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            this.log.debug("Exception while stopping", t);
        }
        try {
            if (this.configuration.connectionFactory() instanceof ManagedConnectionFactory) {
                this.log.tracef("Stopping mananged connection factory: %s", (Object)this.connectionFactory);
                this.connectionFactory.stop();
            }
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            } else {
                t.addSuppressed(cause);
            }
            this.log.debug("Exception while stopping", t);
        }
        if (cause != null) {
            throw new PersistenceException("Exceptions occurred while stopping store", cause);
        }
    }

    @Override
    public void clear() {
        Connection conn = null;
        Statement statement = null;
        try {
            String sql = this.tableManager.getDeleteAllRowsSql();
            conn = this.connectionFactory.getConnection();
            statement = conn.createStatement();
            int result = statement.executeUpdate(sql);
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (SQLException ex) {
            try {
                this.log.failedClearingJdbcCacheStore(ex);
                throw new PersistenceException("Failed clearing cache store", ex);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(statement);
                this.connectionFactory.releaseConnection(conn);
                throw throwable;
            }
        }
        JdbcUtil.safeClose(statement);
        this.connectionFactory.releaseConnection(conn);
    }

    @Override
    public void commit(Transaction tx) {
        try {
            Connection connection = this.getTxConnection(tx);
            connection.commit();
        }
        catch (SQLException e) {
            this.log.sqlFailureTxCommit(e);
            throw new PersistenceException(String.format("Error during commit of JDBC transaction (%s)", tx), e);
        }
        finally {
            this.destroyTxConnection(tx);
        }
    }

    @Override
    public void rollback(Transaction tx) {
        try {
            Connection connection = this.getTxConnection(tx);
            connection.rollback();
        }
        catch (SQLException e) {
            this.log.sqlFailureTxRollback(e);
            throw new PersistenceException(String.format("Error during rollback of JDBC transaction (%s)", tx), e);
        }
        finally {
            this.destroyTxConnection(tx);
        }
    }

    protected Connection getTxConnection(Transaction tx) {
        Connection connection = this.transactionConnectionMap.get(tx);
        if (connection == null) {
            connection = this.connectionFactory.getConnection();
            this.transactionConnectionMap.put(tx, connection);
        }
        return connection;
    }

    protected void destroyTxConnection(Transaction tx) {
        Connection connection = this.transactionConnectionMap.remove(tx);
        if (connection != null) {
            this.connectionFactory.releaseConnection(connection);
        }
    }

    public void initializeConnectionFactory(ConnectionFactory connectionFactory) throws PersistenceException {
        this.connectionFactory = connectionFactory;
        this.tableManager = this.getTableManager();
        this.tableManager.setCacheName(this.cacheName);
        this.tableManager.start();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected ByteBuffer marshall(Object obj) throws PersistenceException, InterruptedException {
        try {
            return this.ctx.getMarshaller().objectToBuffer(obj);
        }
        catch (IOException e) {
            this.log.errorMarshallingObject(e, obj);
            throw new PersistenceException("I/O failure while marshalling object: " + obj, e);
        }
    }

    protected <T> T unmarshall(InputStream inputStream) throws PersistenceException {
        try {
            return (T)this.ctx.getMarshaller().objectFromInputStream(inputStream);
        }
        catch (IOException e) {
            this.log.ioErrorUnmarshalling(e);
            throw new PersistenceException("I/O error while unmarshalling from stream", e);
        }
        catch (ClassNotFoundException e) {
            this.log.unexpectedClassNotFoundException(e);
            throw new PersistenceException("*UNEXPECTED* ClassNotFoundException. This should not happen as Bucket class exists", e);
        }
    }
}

