/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.transaction.Transaction;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.BatchModification;

public interface PersistenceManager
extends Lifecycle {
    public void preload();

    public void disableStore(String var1);

    public <T> Set<T> getStores(Class<T> var1);

    public Collection<String> getStoresAsString();

    public void purgeExpired();

    public void clearAllStores(AccessMode var1);

    public boolean deleteFromAllStores(Object var1, AccessMode var2);

    public void processOnAllStores(KeyFilter var1, AdvancedCacheLoader.CacheLoaderTask var2, boolean var3, boolean var4);

    public void processOnAllStores(Executor var1, KeyFilter var2, AdvancedCacheLoader.CacheLoaderTask var3, boolean var4, boolean var5);

    public void processOnAllStores(KeyFilter var1, AdvancedCacheLoader.CacheLoaderTask var2, boolean var3, boolean var4, AccessMode var5);

    public void processOnAllStores(Executor var1, KeyFilter var2, AdvancedCacheLoader.CacheLoaderTask var3, boolean var4, boolean var5, AccessMode var6);

    public MarshalledEntry loadFromAllStores(Object var1, InvocationContext var2);

    public AdvancedCacheLoader getStateTransferProvider();

    public int size();

    public void setClearOnStop(boolean var1);

    public void writeToAllNonTxStores(MarshalledEntry var1, AccessMode var2);

    public void prepareAllTxStores(Transaction var1, BatchModification var2, AccessMode var3) throws PersistenceException;

    public void commitAllTxStores(Transaction var1, AccessMode var2);

    public void rollbackAllTxStores(Transaction var1, AccessMode var2);

    public static enum AccessMode {
        BOTH{

            @Override
            protected boolean canPerform(StoreConfiguration configuration) {
                return true;
            }
        }
        ,
        SHARED{

            @Override
            protected boolean canPerform(StoreConfiguration configuration) {
                return configuration.shared();
            }
        }
        ,
        PRIVATE{

            @Override
            protected boolean canPerform(StoreConfiguration configuration) {
                return !configuration.shared();
            }
        };


        protected abstract boolean canPerform(StoreConfiguration var1);
    }
}

