package org.jgroups.tests;

import org.jgroups.util.RingBuffer;
import org.jgroups.util.Util;

import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla2  {
    protected final RingBuffer<Integer> rb=new RingBuffer<>(Integer.class, 8);


    protected static final BiConsumer<Integer,Integer> SPIN=(it,spins) -> {;};
    protected static final BiConsumer<Integer,Integer> YIELD=(it,spins) -> Thread.yield();
    protected static final BiConsumer<Integer,Integer> PARK=(it,spins) -> LockSupport.parkNanos(1);
    protected static final BiConsumer<Integer,Integer> SPIN_PARK=(it, spins) -> {
        if(it < spins/10)
            return; // spin for the first 10% of all iterations, then switch to park()
        LockSupport.parkNanos(1);
    };
    protected static final BiConsumer<Integer,Integer> SPIN_YIELD=(it, spins) -> {
        if(it < spins/10)
            ;           // spin for the first 10% of the total number of iterations
        Thread.yield(); //, then switch to yield()
    };


    protected void start() throws InterruptedException {
        new Adder().start();
        rb.waitForMessages(40, SPIN_PARK);

        Integer msg=rb.take();
        System.out.println("msg = " + msg);
    }

    protected class Adder extends Thread {
        public void run() {
            Util.sleep(50000);
            try {
                rb.put(322649);
            }
            catch(InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new bla2().start();
    }



}



