/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.BlockingRunnable;

public abstract class BaseBlockingRunnable
implements BlockingRunnable {
    protected final BasePerCacheInboundInvocationHandler handler;
    protected final CacheRpcCommand command;
    protected final Reply reply;
    protected final boolean sync;
    protected Response response;

    protected BaseBlockingRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply, boolean sync) {
        this.handler = handler;
        this.command = command;
        this.reply = reply;
        this.sync = sync;
    }

    @Override
    public void run() {
        if (this.sync) {
            this.runSync();
        } else {
            this.runAsync();
        }
    }

    private void runSync() {
        try {
            CompletableFuture<Response> beforeFuture = this.beforeInvoke();
            if (beforeFuture != null) {
                this.response = beforeFuture.join();
                if (this.response != null) {
                    return;
                }
            }
            CompletableFuture<Response> commandFuture = this.handler.invokeCommand(this.command);
            this.response = commandFuture.join();
            this.afterInvoke();
        }
        catch (Throwable t) {
            this.afterCommandException(this.unwrap(t));
        }
        finally {
            this.reply.reply(this.response);
            this.onFinally();
        }
    }

    private void runAsync() {
        CompletableFuture<Response> beforeFuture = this.beforeInvoke();
        if (beforeFuture == null) {
            this.invoke();
        } else {
            beforeFuture.whenComplete((rsp, throwable) -> {
                if (rsp != null) {
                    this.response = rsp;
                    this.reply.reply(rsp);
                    this.onFinally();
                } else if (throwable != null) {
                    this.afterCommandException(this.unwrap((Throwable)throwable));
                    this.reply.reply(this.response);
                    this.onFinally();
                } else {
                    this.invoke();
                }
            });
        }
    }

    private void invoke() {
        CompletableFuture<Response> commandFuture;
        try {
            commandFuture = this.handler.invokeCommand(this.command);
        }
        catch (Throwable t) {
            this.afterCommandException(this.unwrap(t));
            this.reply.reply(this.response);
            this.onFinally();
            return;
        }
        commandFuture.whenComplete((rsp, throwable) -> {
            try {
                if (throwable == null) {
                    this.response = rsp;
                    this.afterInvoke();
                } else {
                    this.afterCommandException(this.unwrap((Throwable)throwable));
                }
            }
            finally {
                this.reply.reply(this.response);
                this.onFinally();
            }
        });
    }

    private Throwable unwrap(Throwable throwable) {
        if (throwable instanceof CompletionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    private void afterCommandException(Throwable throwable) {
        this.response = throwable instanceof InterruptedException ? this.handler.interruptedException(this.command) : (throwable instanceof OutdatedTopologyException ? this.handler.outdatedTopology((OutdatedTopologyException)throwable) : (throwable instanceof IllegalLifecycleStateException ? CacheNotFoundResponse.INSTANCE : this.handler.exceptionHandlingCommand(this.command, throwable)));
        this.onException(throwable);
    }

    protected void onFinally() {
    }

    protected void onException(Throwable throwable) {
    }

    protected void afterInvoke() {
    }

    protected CompletableFuture<Response> beforeInvoke() {
        return null;
    }
}

