/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistCacheWriterInterceptor
extends CacheWriterInterceptor {
    private DistributionManager dm;
    private Transport transport;
    private Address address;
    private static final Log log = LogFactory.getLog(DistCacheWriterInterceptor.class);
    private boolean isUsingLockDelegation;
    private ClusteringDependentLogic cdl;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(DistributionManager dm, Transport transport, ClusteringDependentLogic cdl) {
        this.dm = dm;
        this.transport = transport;
        this.cdl = cdl;
    }

    @Start(priority=25)
    private void setAddress() {
        this.address = this.transport.getAddress();
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            PutKeyValueCommand putKeyValueCommand = (PutKeyValueCommand)rCommand;
            Object key = putKeyValueCommand.getKey();
            if (!this.isStoreEnabled(putKeyValueCommand) || rCtx.isInTxScope() || !putKeyValueCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, putKeyValueCommand, putKeyValueCommand.getKey())) {
                return rv;
            }
            this.storeEntry(rCtx, key, putKeyValueCommand);
            if (this.getStatisticsEnabled()) {
                this.cacheStores.incrementAndGet();
            }
            return rv;
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            PutMapCommand putMapCommand = (PutMapCommand)rCommand;
            if (!this.isStoreEnabled(putMapCommand) || rCtx.isInTxScope()) {
                return rv;
            }
            Map<Object, Object> map = putMapCommand.getMap();
            int count = 0;
            for (Object key : map.keySet()) {
                if (this.isUsingLockDelegation && putMapCommand.isForwarded() && !this.dm.getPrimaryLocation(key).equals(rCtx.getOrigin()) || !this.isProperWriter(rCtx, putMapCommand, key)) continue;
                this.storeEntry(rCtx, key, putMapCommand);
                ++count;
            }
            if (this.getStatisticsEnabled()) {
                this.cacheStores.getAndAdd(count);
            }
            return rv;
        });
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            RemoveCommand removeCommand = (RemoveCommand)rCommand;
            Object key = removeCommand.getKey();
            if (!this.isStoreEnabled(removeCommand) || rCtx.isInTxScope() || !removeCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, removeCommand, key)) {
                return rv;
            }
            boolean resp = this.persistenceManager.deleteFromAllStores(key, this.skipSharedStores(rCtx, key, removeCommand) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            log.tracef("Removed entry under key %s and got response %s from CacheStore", key, (Object)resp);
            return rv;
        });
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            ReplaceCommand replaceCommand = (ReplaceCommand)rCommand;
            Object key = replaceCommand.getKey();
            if (!this.isStoreEnabled(replaceCommand) || rCtx.isInTxScope() || !replaceCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, replaceCommand, replaceCommand.getKey())) {
                return rv;
            }
            this.storeEntry(rCtx, key, replaceCommand);
            if (this.getStatisticsEnabled()) {
                this.cacheStores.incrementAndGet();
            }
            return rv;
        });
    }

    @Override
    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !this.cdl.localNodeIsPrimaryOwner(key) || command.hasAnyFlag(FlagBitSets.SKIP_SHARED_CACHE_STORE);
    }

    @Override
    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
            return true;
        }
        if (this.isUsingLockDelegation && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL) && ctx.isOriginLocal() && !this.dm.getPrimaryLocation(key).equals(this.address)) {
            log.tracef("Skipping cache store on the originator because it is not the primary owner of key %s", (Object)Util.toStr(key));
            return false;
        }
        if (!this.dm.getWriteConsistentHash().isKeyLocalToNode(this.address, key)) {
            log.tracef("Skipping cache store since the key is not local: %s", key);
            return false;
        }
        return true;
    }
}

