/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationWriterInterceptor
extends DDAsyncInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    protected PersistenceManager persistenceManager;
    private static final Log log = LogFactory.getLog(PassivationWriterInterceptor.class);

    protected Log getLog() {
        return log;
    }

    @Inject
    protected void init(PersistenceManager pm) {
        this.persistenceManager = pm;
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.isStoreEnabled(command) && !ctx.isInTxScope()) {
            this.persistenceManager.clearAllStores(ctx.isOriginLocal() ? PersistenceManager.AccessMode.BOTH : PersistenceManager.AccessMode.PRIVATE);
        }
        return this.invokeNext(ctx, command);
    }

    protected boolean isStoreEnabled(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_CACHE_STORE)) {
            if (this.trace) {
                log.trace("Skipping cache store since the call contain a skip cache store flag");
            }
            return false;
        }
        return true;
    }
}

