/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.dns;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.jgroups.ping.dns.DnsRecord;

public class GetServicePort
implements Callable<Integer> {
    private final String _serviceName;

    public GetServicePort(String serviceName) {
        this._serviceName = serviceName;
    }

    @Override
    public Integer call() throws Exception {
        Set<DnsRecord> dnsRecords = this.getDnsRecords(this._serviceName);
        Iterator<DnsRecord> iterator = dnsRecords.iterator();
        if (iterator.hasNext()) {
            DnsRecord dnsRecord = iterator.next();
            return dnsRecord.getPort();
        }
        return null;
    }

    private Set<DnsRecord> getDnsRecords(String serviceName) throws Exception {
        TreeSet<DnsRecord> dnsRecords = new TreeSet<DnsRecord>();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        env.put("com.sun.jndi.dns.recursion", "false");
        env.put("com.sun.jndi.dns.timeout.initial", "2000");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attrs = ctx.getAttributes(serviceName, new String[]{"SRV"});
        NamingEnumeration<?> servers = attrs.get("SRV").getAll();
        while (servers.hasMore()) {
            DnsRecord record = DnsRecord.fromString((String)servers.next());
            dnsRecords.add(record);
        }
        return dnsRecords;
    }
}

