/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class PrimaryAckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 30;
    private static final Type[] CACHED_TYPE = Type.values();
    private long id;
    private Object returnValue;
    private Type type;
    private CommandAckCollector commandAckCollector;
    private int topologyId;

    public PrimaryAckCommand() {
        super(null);
    }

    public PrimaryAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    private static Type valueOf(int index) {
        return CACHED_TYPE[index];
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        switch (this.type) {
            case SUCCESS_WITH_BOOL_RETURN_VALUE: 
            case SUCCESS_WITH_RETURN_VALUE: 
            case SUCCESS_WITHOUT_RETURN_VALUE: {
                this.commandAckCollector.primaryAck(this.id, this.returnValue, true, this.getOrigin(), this.topologyId);
                break;
            }
            case UNSUCCESSFUL_WITH_BOOL_RETURN_VALUE: 
            case UNSUCCESSFUL_WITH_RETURN_VALUE: 
            case UNSUCCESSFUL_WITHOUT_RETURN_VALUE: {
                this.commandAckCollector.primaryAck(this.id, this.returnValue, false, this.getOrigin(), this.topologyId);
            }
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 30;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeInt(this.topologyId);
        output.writeLong(this.id);
        MarshallUtil.marshallEnum(this.type, output);
        switch (this.type) {
            case SUCCESS_WITH_RETURN_VALUE: 
            case UNSUCCESSFUL_WITH_RETURN_VALUE: {
                output.writeObject(this.returnValue);
                break;
            }
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.topologyId = input.readInt();
        this.id = input.readLong();
        this.type = MarshallUtil.unmarshallEnum(input, PrimaryAckCommand::valueOf);
        assert (this.type != null);
        switch (this.type) {
            case SUCCESS_WITH_RETURN_VALUE: 
            case UNSUCCESSFUL_WITH_RETURN_VALUE: {
                this.returnValue = input.readObject();
                break;
            }
            case SUCCESS_WITH_BOOL_RETURN_VALUE: {
                this.returnValue = true;
                break;
            }
            case UNSUCCESSFUL_WITH_BOOL_RETURN_VALUE: {
                this.returnValue = false;
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "PrimaryAckCommand{id=" + this.id + ", returnValue=" + this.returnValue + ", type=" + (Object)((Object)this.type) + ", topologyId=" + this.topologyId + '}';
    }

    public void setCommandAckCollector(CommandAckCollector commandAckCollector) {
        this.commandAckCollector = commandAckCollector;
    }

    void initCommandInvocationIdAndTopologyId(long id, int topologyId) {
        this.id = id;
        this.topologyId = topologyId;
    }

    void initWithReturnValue(boolean success, Object returnValue) {
        this.returnValue = returnValue;
        this.type = success ? Type.SUCCESS_WITH_RETURN_VALUE : Type.UNSUCCESSFUL_WITH_RETURN_VALUE;
    }

    void initWithBoolReturnValue(boolean success) {
        this.returnValue = success;
        this.type = success ? Type.SUCCESS_WITH_BOOL_RETURN_VALUE : Type.UNSUCCESSFUL_WITH_BOOL_RETURN_VALUE;
    }

    void initWithoutReturnValue(boolean success) {
        this.type = success ? Type.SUCCESS_WITHOUT_RETURN_VALUE : Type.UNSUCCESSFUL_WITHOUT_RETURN_VALUE;
    }

    private static enum Type {
        SUCCESS_WITH_RETURN_VALUE,
        SUCCESS_WITH_BOOL_RETURN_VALUE,
        SUCCESS_WITHOUT_RETURN_VALUE,
        UNSUCCESSFUL_WITH_RETURN_VALUE,
        UNSUCCESSFUL_WITH_BOOL_RETURN_VALUE,
        UNSUCCESSFUL_WITHOUT_RETURN_VALUE;

    }
}

